package org.trinet.jiggle;

import java.text.*;
import java.awt.*;
import java.util.*;
import javax.swing.event.*;
import java.awt.event.*;
import javax.swing.*;

import org.trinet.jasi.*;

/** A list of WFPanels. Amoung other functions this class can be a listener to
* the SelectedWFViewModel and set
* a newly selected WFView's WFPanel as selected. This way we don't have to
* put a SelectedWFViewModel ChangeListener on every WFPanel (there can be 1200+).*/
public class WFPanelList extends ArrayList {

     MasterView mv;

     WFPanel selectedWFPanel = null;

     SelectedWFViewListener selectedWFViewListener =
                            new SelectedWFViewListener();

     public WFPanelList() {
     }

     public WFPanelList(MasterView mv) {
       setMasterView(mv);
     }
     
     public void setMasterView(MasterView mview) {
       removeListeners(mv);               // nuke old listeners
       mv = mview;
       addListeners(mv);
     }

    /** Add model listeners to this MasterView's models. */
    protected void addListeners (MasterView mv) {

     if (mv != null && mv.masterWFViewModel != null) {
         mv.masterWFViewModel.addChangeListener(selectedWFViewListener);
     }
    }
    /** Remove model listeners to this MasterView's models. */
    protected void removeListeners (MasterView mv) {

     if (mv != null && mv.masterWFViewModel != null) {
         mv.masterWFViewModel.removeChangeListener(selectedWFViewListener);
     }
    }

    /** Set value of 'showPhaseCues' for whole list. Repaints. */
    public void setShowPhaseCues(boolean tf) {
      WFPanel[] mwfp = getArray();
      for ( int i=0; i < mwfp.length; i++)  {
        mwfp[i].setShowPhaseCues(tf);;
      }
    }

/**
 * Return the WFPanel that contains this WFView. Returns null if not found.
 */
public WFPanel get (WFView wfv) {

//  synchronized (this) {
    WFPanel[] mwfp = getArray();
    for ( int i=0; i < mwfp.length; i++)  {
	if (mwfp[i].wfv == wfv) return mwfp[i];
    }

    return null;
//  }
}
/**
 * Return the WFPanel that contains this Channel. Returns null if not found.
 */
public WFPanel get (Channel chan) {
//  synchronized (this) {
    WFPanel[] mwfp = getArray();
    for ( int i=0; i < mwfp.length; i++)  {
	if (mwfp[i].wfv.getChannelObj().equals(chan)) return mwfp[i];
    }

    return null;
//  }
}

/** Return list as array of WFPanels. */
public WFPanel[] getArray() {
  return (WFPanel[]) this.toArray(new WFPanel[0]);
}

/** INNER CLASS: Handle changes to the selected WFView. */
      class SelectedWFViewListener implements ChangeListener {
     	public void stateChanged (ChangeEvent changeEvent) {

          // unselect the old one
            if (selectedWFPanel != null) selectedWFPanel.setSelected(false);

            WFView newWFV = ((SelectedWFViewModel) changeEvent.getSource()).get();

            // select the new one
            selectedWFPanel = get(newWFV);
            if (selectedWFPanel != null) selectedWFPanel.setSelected(true);

          }
      }  // end of WFViewListener
} 