
//Copyright:    Copyright (c) 2001
//Author:       Doug Given
//Company:      USGS

package org.trinet.jiggle;

import java.awt.*;
import java.util.Collection;
//import java.util.ArrayList;
import javax.swing.*;
import javax.swing.border.*;

import java.awt.event.*;
import java.util.*;

import java.util.ArrayList;
import org.trinet.jasi.*;

/** A Dialog panel for choosing the ChannelTimeWindowModel */
// This component was built using JBuilder's design tool so the code is messy.

public class DPChannelTimeWindowModel extends JPanel {

      JiggleProperties props;

      /** The currently selected model */
      ChannelTimeWindowModel selectedModel = null;

      JPanel middlePanel = new JPanel();
      TitledBorder titledBorder2;

      BorderLayout borderLayout3 = new BorderLayout();
      JLabel instructionLabel = new JLabel();
      BorderLayout borderLayout1 = new BorderLayout();
      JPanel topPanel = new JPanel();
      JTextArea textArea = new JTextArea();
//      JLabel modelTextArea = new JLabel();
      JComboBox modelBox ;
      JLabel modelBoxLabel = new JLabel();

/** Allow selection of waveform reading mode. */
     public DPChannelTimeWindowModel(JiggleProperties properties) {

          props = properties;

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
     }

/** Build the GUI.
This component was built using JBuilder's design tool so the code is messy. */
     private void jbInit() throws Exception {
          titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(148, 145, 140)),"Channel/Time Window Model");

	  textArea.setRows(5);
	  textArea.setBackground(Color.white);
	  this.setLayout(borderLayout3);

	  makeModelBox();

          middlePanel.setBorder(titledBorder2);
          middlePanel.setLayout(borderLayout1);

	  instructionLabel.setText("Choose a model for defining channels and time windows");

	  // buttons

	  this.setBackground(Color.white);

          modelBoxLabel.setText("Model Name");
	  topPanel.add(modelBoxLabel, null);
	  topPanel.add(modelBox, null);

	  middlePanel.add(topPanel, BorderLayout.NORTH);
	  middlePanel.add(textArea, BorderLayout.CENTER);
	  middlePanel.add(instructionLabel, BorderLayout.SOUTH);
	  this.add(middlePanel, BorderLayout.CENTER);
     }

/** Fill the JComboBox with the items in the wsgList */
     private void makeModelBox () {
       modelBox = new JComboBox();

        if (props.getChannelTimeWindowModelList() != null) {
          createCTWList();            // populate the box from the list

	  // add AFTER box's model is populated else adding items fires events
	   modelBox.addActionListener(new java.awt.event.ActionListener() {
	     public void actionPerformed(ActionEvent e) {
		modelBox_actionPerformed(e);
	     }
	   });

       } else {
       // This should never happen. JiggleProperties defines a default
	 textArea.setText("No models defined. \n"+
		      "Add 'channelTimeWindowModelList' and 'currentChannelTimeWindowModel'\n"+
		      "to your properties file.");
       }

      }

       /** Instantiate the ChannelTimeWindowModel objects for display in the JComboBox.
        *  Must instantiate them to get "name" and "explanations" */
       private void createCTWList () {

	  //ArrayList modelList = (ArrayList) props.getChannelTimeWindowModelList();
	  String modelClassList[] = props.getChannelTimeWindowModelStringArray();

          // populate the box with Models
	  // NOTE: the model.toString() method is called to make the JComboBox labels
          for (int i = 0; i<modelClassList.length; i++) {
		ChannelTimeWindowModel model = ChannelTimeWindowModel.getInstance(modelClassList[i]);
	        if (model != null) {
		    modelBox.addItem(model);  // THIS SELECTS IT! add to selection box
		    // set the selected model
		    String x = model.getClassname();
		    String y = props.getCurrentChannelTimeWindowModelClassName();
		    if (model.getClassname().equals(props.getCurrentChannelTimeWindowModelClassName())) {
			setSelectedModel(model);
			modelBox.setSelectedItem(model);
		    }
	        }
          }

       }
       /** Action performed when JComboBox selection is made. Selects a model. */
       void modelBox_actionPerformed(ActionEvent e) {
	    JComboBox src = (JComboBox) e.getSource();
	    ChannelTimeWindowModel dtwm = (ChannelTimeWindowModel) src.getSelectedItem();
	    if (dtwm != null) {
		setSelectedModel(dtwm);
	    }
       }

       /** Set selected model to this one.*/
       protected void setSelectedModel(ChannelTimeWindowModel model) {
	    if (model != selectedModel) {
		selectedModel = model;
		setModelText(model);
		// change it in the properties
		props.setChannelTimeWindowModel(model.getClassname());
	    }
       }
/*
       protected void setSelectedModel(String modelName) {
            ChannelTimeWindowModel model = ChannelTimeWindowModel.getInstance(modelName);
	    if (model != null) setSelectedModel(model);
       }
*/
       /** Retrun the name of the selected model. */
       public ChannelTimeWindowModel getSelectedModel () {
	  return selectedModel;
       }

  /** Populate the text area. Example:
   *  <tt>
   *  DataSource Model
   *  org.trinet.jasi.DataSourceChannelTimeModel
   *  Channels defined by dbase associations.
   *  </tt>
   */
       protected void setModelText(ChannelTimeWindowModel model) {
	  String str =
              model.getModelName()+"\n"+
              model.getClass().getName()+"\n"+
              "Min dist = "+model.getMinDistance()+" Max dist = "+model.getMaxDistance()+"\n"+
              "Max channels = "+model.getMaxChannels()+"\n"+
              model.getExplanation();
          textArea.setText(str);
       }


// ///////////////////////////////////////////////////
 public static void main(String s[]) {

        JiggleProperties props = new JiggleProperties("properties");

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

          DPChannelTimeWindowModel dia = new DPChannelTimeWindowModel(props);

          frame.getContentPane().add(dia);

        frame.pack();
        frame.setVisible(true);

    }

}
