package org.trinet.jiggle;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.*;

/**
  * This dialog can be centered. Also has a ColumnLayout
  */
public class CenteredDialog extends JDialog {

     /** Status for dialog when closed. */
     int returnValue = JOptionPane.CLOSED_OPTION;


     public CenteredDialog() {
     }

     public CenteredDialog (Frame frame, String title, boolean modal) {

       super(frame, title, modal);
       centerDialog();
     }

     /** Returns status of the button that closed the dialog. */
     public int getButtonStatus () {
        return returnValue;
     }
/**
 * Center the dialog on the screen
 */
   public void centerDialog() {
     Dimension screenSize = this.getToolkit().getScreenSize();
	Dimension size = this.getSize();
	screenSize.height = screenSize.height/2;
	screenSize.width = screenSize.width/2;
	size.height = size.height/2;
	size.width = size.width/2;
	int y = screenSize.height - size.height;
	int x = screenSize.width - size.width;
	this.setLocation(x,y);
    }
}

