package org.trinet.jasi;

import java.text.*;
import java.util.*;
import java.io.*;
import java.net.InetAddress;

import org.trinet.jasi.*;
import org.trinet.util.GenericPropertyList;
/**

ChauvenetThreshold = 0.5
MinCuoffDist
MaxCutffDist
StepCutoffDist
DefaultCutoffDist
MinChannels
PreBuffer
MlClipValue

 * @see: PropertyList
 */


public class SoCalMLProperties extends GenericPropertyList {

    /** True to turn on debug messages. */
    static boolean debug = false;

    static final String DEFAULT_FILENAME = "SoCalMLProperties";

/**
 *  Construtor: reads default property file and System properties
 */

    public SoCalMLProperties() {
           this (DEFAULT_FILENAME);
    }

/**
 *  Construtor: Makes a COPY of a property list. Doesn't read the files.
 */
    public SoCalMLProperties(GenericPropertyList props)
    {
           super(props);
           setDefaultProperties();
    }

/**
 *  Read in a property file.
 */
    public SoCalMLProperties(String file)
    {
     	super(null, file);
          setDefaultProperties();
    }

/**
 * Set values for certain essential properties so the program will work in the absence of
 * a default 'properties' file.
 */
    public void setDefaultProperties() {

       setProperty ("ChauvenetThreshold", 0.5);
       setProperty ("MinCuoffDist", 100.0);
       setProperty ("MaxCutffDist", 800.0);
       setProperty ("StepCutoffDist", 100.0);
       setProperty ("DefaultCutoffDist", 300.0);
       setProperty ("MinChannels", 10);
       setProperty ("PreBuffer", 1.0);
       setProperty ("MlClipValue", 6.5);
    }

/**
* Save all the environment's properties.
*/
     public void save() {

	super.saveProperties ("--- SoCalML Properties --- [" + getUserPropertiesFileName()+"] *DO NOT EDIT*");      // save user properties
    }

    public static void main (String args[])
    {
         SoCalMLProperties props = new SoCalMLProperties();

         props.list(System.out);
         props.save();
         
    }

} // end of class
