package org.trinet.jasi;

import java.util.*;

/**
 * Provides comparitor() method to sort a list of Channelable objects by distance
 * and component name. The distance from the sort point must already be set
 * for the compared objects with channelable.setDistance(double). <p>
 */

public class ChannelSorter implements Comparator {

    /** Comparitor for component sort. */
    ComponentSorter componentSorter = new ComponentSorter();

    /** */
    public int compare (Object o1, Object o2) {

	Channelable ch1 = (Channelable) o1;
	Channelable ch2 = (Channelable) o2;

	double diff = ch1.getDistance() - ch2.getDistance();

     if (diff < 0.0) {
	    return -1;
     } else if (diff > 0.0) {
	    return  1;
	} else {		// same dist sort by component type
	   return componentSorter.compare(
                           ch1.getChannelObj().getSeedchan(),
					  ch2.getChannelObj().getSeedchan());
	}
    }

} // end of ChannelSorter inner class
