      LOGICAL FUNCTION BOX2 (Y,X,Z,KLAS,NAME,FULNAM)
C--DETERMINES WHETHER A POINT IS IN THE REGION NUMBER KLAS.
C  ONLY ONE REGION IS TESTED. FOR NET 2 (NORTHERN CALIF)

C--INPUTS:
C  Y     LATITUDE, DECIMAL DEGREES
C  X     LONGITUDE, DECIMAL DEGREES, POSITIVE EAST
C  Z     DEPTH, KM
C  KLAS  REGION NUMBER TO TEST

C--OUTPUTS:
C  BOX2  TRUE IF POINT IS IN REGION OR ON EDGE, FALSE OTHERWISE
C  NAME  3-LETTER NAME FOR REGION IF INSIDE
C  FULNAM  THE FULL (25 CHAR. MAX) REGION NAME

      PARAMETER (NVEXS=242)            !NUMBER OF VERTEX POINTS
      PARAMETER (NREGS=103)            !NUMBER OF DEFINED REGIONS
      PARAMETER (NLIST=636)            !NUMBER OF VERTICIES IN LIST
      PARAMETER (NLP1=637)            !NLIST + 1

      DIMENSION PX(NVEXS), PY(NVEXS)      !VERTEX COORDS
      CHARACTER*3 NAME, NAM(NREGS)      !SHORT REGION NAMES
      CHARACTER*25 FULNAM,FN(NREGS)      !LONG REGION NAMES
      INTEGER JVEX(NLIST)      !ORDERED LIST OF VERTICIES FOR EACH REGION

C--POINTER TO FIRST VERTEX IN JVEX LIST FOR EACH REGION
      DIMENSION NS(NREGS+1)
C--FICTITIOUS POINTER TO LAST VERTEX PLUS 1
      DATA NS(NREGS+1) /NLP1/

      INCLUDE 'box2.inc'

C--ACCUMULATE THE SIGNED CROSSING NUMBERS WITH INSID
      INSID=0
C--FIRST VERTEX NUMBERS OF THIS AND NEXT REGION
      N1=NS(KLAS)
      N2=NS(KLAS+1)

C--LOOP OVER POLYGON EDGES TO SEE IF -X AXIS IS CROSSED
      DO 20 I=N1,N2-2
C--THESE ARE THE TWO VERTEX NUMBERS FOR THIS SEGMENT
        J1=JVEX(I)
        J2=JVEX(I+1)

C--CALC THE CROSSING NUMBER, TRANSLATING TEST POINT TO ORIGIN
        ISIC=KSIC (PX(J1)-X, PY(J1)-Y, PX(J2)-X, PY(J2)-Y)
C--WE WILL SAY WE ARE IN THE REGION IF TEST POINT IS ON EDGE
        IF (ISIC.EQ.4) GOTO 55
20    INSID=INSID+ISIC

C--CHECK THE SEGMENT FROM THE LAST BACK TO THE FIRST VERTEX
      J1=JVEX(N2-1)
      J2=JVEX(N1)
      ISIC=KSIC (PX(J1)-X, PY(J1)-Y, PX(J2)-X, PY(J2)-Y)
      IF (ISIC.EQ.4) GOTO 55
      INSID=INSID+ISIC

C--IF INSID=0, THE POINT IS OUTSIDE
C  IF INSID= +/- 1, THE POINT IS INSIDE
      IF (INSID.NE.0) GOTO 55
      BOX2=.FALSE.
      RETURN

C--POINT IS INSIDE BOX OR ON EDGE
55    BOX2=.TRUE.
      NAME=NAM(KLAS)
      FULNAM=FN(KLAS)
      RETURN
      END
