#
# q2ew configuration file
#
#

 ModuleId       MOD_Q3302EW        # module id for this import,
 RingName       WAVE_RING       # transport ring to use for input/output,

 HeartbeatInt   10              # Heartbeat interval in seconds
                                # this should match the q2ew.desc heartbeat!

 LogFile        2               # If 0, don't write logfile;; if 1, do
                                # if 2, log to module log but not stderr/stdout

## The following config items are from the Q330 side
## of Mountainair.  Their names have been preserved for
## consistancy

udpaddr		192.168.1.165	# The IP address of the Q330
ipport		6000		# A port on the local machine.  This port
				# and this port+1 must be unused.
baseport	5330		# The base port of the Q330 (5330 is default)
dataport	2		# Which dataport on the Q330 to connect to
serialnumber	0x010000069A37E501	# The serial number of the Q330
authcode	0x0		# The authentication code for the Q330
verbosity	0		# global verbosity level
				# 0 : silent
				# 1 : major items
				# 2 : major and minor items
				# 3 : everything

# Values for "diagnostic" (for debugging purposes only) can be found
# in the qmaserv/include/QmaDiag.h file.
diagnostic	0		# Particular diagnostic messages that should
				# always be displayed

startmsg	"Q3302EW Starting"	# Sent to the Q330 via user message
					# when q3302ew starts

statusinterval  5		# time in seconds between status checks.
				# this defines both state of health checking,
				# as well as status output

# State Of Health Thresholds

# Minimum acceptable clock quality.  Set to zero to never warn
# about this.
MinClockQuality 80		# If the clock quality falls below this value,
				# an error is generated.

## These two are measured in mv
MinInputPower   10000		# An error is generated if input power falls
				# below this value
MaxInputPower   14000		# An error is generated if input power goes
				# higher than this value

# There is a seperate MassPosition range defined for each channel.  These
# values are MinMass1Position through MinMass6Position, and MaxMass1Position
# through MaxMass6Position.  An error is inserted into the ring for each
# mass position that is outside of it's acceptable range.

MaxMass1Position 30		
MinMass1Position -10

MaxMass2Position 30
MinMass2Position -10

MaxMass3Position 30
MinMass3Position -10

MaxMass4Position 30
MinMass4Position -10

MaxMass5Position 30
MinMass5Position -10

MaxMass6Position 30
MinMass6Position -10

