#  configuration file for naqsser

MyModuleId        MOD_NAQSSERTG
RingName          WAVE_RING
HeartBeatInt      30
LogFile           1
Debug             0    # 0=no debugging messages
                       # 1=log a few header-type lines per packet.
                       # 2=log header lines plus all data samples per packet.
SocketDebug       0    # 0=off, non-zero=log debug messages (VERBOSE!!!!)

NaqsServer        192.168.103.20 28000   # IP address and Port of NaqsServer
MaxSamplePerMsg   256
DataPath       u:\ptwctide\   # Path to write disk files


# Set up list of channels you want to receive from NaqsServer using
# a 'RequestChannel' command for each channel, with these arguments:
#
#   sta       station code you want to receive data from (no wildcards).
#   chan      channel (component) of data you want to receive (no wildcards).
#   net       2-character network code to label this channel with (no wildcards).
#             NaqsServer supplies its own station and component codes to its clients,
#             but not a network code. The sta and chan codes you supply in this file 
#             must match the codes supplied by NaqsServer. The TYPE_TRACEBUF messages 
#             output to the Earthworm system will be labeled with the sta, chan, net 
#             codes listed in this file.
#
#   pinno     pin number to assign to this channel (0-32767)
#
#   delay     short-term-completion time (in seconds) -1s <= s <= 300s.
#             When NaqsServer misses packets from the field, it will wait for the 
#             given amount of time for the gap to be filled by re-transmitted
#             packets before sending data to naqsser. Specifying delay=0 will 
#             guarantee that packets are in chronological order, without
#             waiting for missed data.
# 
#   sendbuf   Buffer flag:
#               0 = do not send buffered packets for these channels.
#               1 = send buffered packets for these channels.  This effectively
#                   moves the start of the data stream several packets into
#                   the past.  
#             WARNING: if naqsser is auto-restarted with sendbuffer=1, 
#               duplicate data could enter the Earthworm system.
#               Therefore, we strongly recommend setting sendbuffer = 0. 
#
#   dtexp     Expected time between samples (in seconds)
#
#                 sta   chan  net  pinno  delay(s)   sendbuf   dtexp
RequestChannel    PMR    VTZ   AT   2001    45          0       15. 

