/*
 *   THIS FILE IS UNDER RCS - DO NOT MODIFY UNLESS YOU HAVE
 *   CHECKED IT OUT USING THE COMMAND CHECKOUT.
 *
 *    $Id: naqsser.h,v 1.1 2003/02/14 19:45:21 dietz Exp $
 *
 *    Revision history:
 *     Revision 1.1  2003/02/10 22:35:07  whitmore
 *     Initial revision (copied from naqs2ew)
 *
 */

/*   naqsser.h    */
 
#ifndef _NAQSSER_H
#define _NAQSSER_H

#include "naqschassis.h"

#define MAX_SERTGTWC_SIZE  512/* max length of serial tide gage msg     */
#define SAMPLE_LENGTH    10   /* Serial data sample length in bytes     */
#define MAX_SAMPS        16   /* Maximum SERIAL samples per incoming msg*/
#define STATION_LEN      6    /* max string-length of station code      */ 
#define CHAN_LEN         8    /* max string-length of channel code      */
#define NETWORK_LEN      8    /* max string-length of network code      */ 

#define SER_NOTAVAILABLE 0    /* SER not served by current NaqsServer   */
#define SER_AVAILABLE    1    /* SER is served by current NaqsServer    */

#define ABS(X) (((X) >= 0) ? (X) : -(X))
 
/* Structure for tracking requested channels
 *******************************************/
typedef struct _SER_INFO {
   char               sta[STATION_LEN];
   char               chan[CHAN_LEN];
   char               net[NETWORK_LEN];
   int                pinno;
   int                delay;
   int                sendbuffer;
   int                flag;
   int                first;      /* 0 until packet processed      */
   double             texp;       /* expected time of next packet  */
   double             dtexp;      /* expected time between samples */
   NMX_CHANNEL_INFO   info;
} SER_INFO;

/* Function Prototypes 
 *********************/
/* serchannels.c */
int       SelectSerChannels( NMX_CHANNEL_INFO *chinf, int nch, 
                             SER_INFO *req, int nreq ); 
SER_INFO *FindSerChannel( SER_INFO *list, int nlist, int chankey );

#endif
