package Tester;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.trinet.jasi.*;
import org.trinet.jasi.coda.*;
import org.trinet.util.graphics.task.*;

/** Example of progress monitorable Mc task using stand alone dialogs as a GUI. */
public class McaProgressTester {
    static Solution sol;
    static Collection waveList;
    //static Magnitude magnitude;

    public static final void main(String [] args) {

        System.out.println("Creating new database connection");
        final DataSource dataSource = new DataSource(
        "jdbc:oracle:thin:@k2.gps.caltech.edu:1521:k2db",
        "oracle.jdbc.driver.OracleDriver",
        "trinetdb",
        "calgs"
        ); // use defaults
        try {
        System.out.println("Creating new mca thread group");
        final ThreadGroup jiggleThreadGroup = new ThreadGroup("JiggleMCA");
        jiggleThreadGroup.setDaemon(false);

        final int id = 10983128;  // a random test event

        // Let's create separate threads to get db info for event
        // note java resource access bug perhaps have thread create a SimpleDataFormat ???
        System.out.println("Creating new Solution.create().getById()");
        Thread solThread = 
            new Thread(jiggleThreadGroup,
                       new Runnable () {
                           public void run() {
                               java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(); 
                               McaProgressTester.sol = Solution.create().getById(id);
                           }
                       },
                       "Solution"); 
        solThread.setDaemon(true);
        solThread.start();

        System.out.println("Creating new Waveform.create().getBySolutionId()");
        Thread wlistThread =
            new Thread(jiggleThreadGroup,
                       new Runnable () {
                           public void run() {
                               java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(); 
                               McaProgressTester.waveList = Waveform.create().getBySolutionId(id);
                           }
                       },
                       "WaveList"); 
        wlistThread.setDaemon(true);
        wlistThread.start();

// EXAMPLE progress bar monitor
        System.out.println("Waiting for channelList, loading to complete");
        // Now let's Load channelList by measured progress thread
        ChannelList channelList = null;
        MonitorableChannelListTask channelTask = 
            new MonitorableChannelListTask() {
                public void finished() {
                    System.out.println("Finished channelList load count: " + ((Collection) getTaskResult()).size()); 
                }
            };

        channelTask.setThreadGroup(jiggleThreadGroup);
        channelTask.setThreadName("ChannelList");
        channelTask.setProgressTimerDelay(100);

        TaskMonitorDialog channelDialog = new TaskMonitorDialog();
        channelDialog.setTask(channelTask);
        channelDialog.setProgressMeterVisible(true);
        channelDialog.setLocation(0,0);
        channelDialog.startTask();

        // System.out.println("MAIN: threads running: " + jiggleThreadGroup.activeCount()); //DEBUG
        //jiggleThreadGroup.list(); // DEBUG

        // block here til channel loading thread is done
        channelList = (ChannelList) channelTask.getTaskResult();

        // block here til solution data is done
        //System.out.println(" Waiting for solution db data");
        try {
           solThread.join();
        }
        catch (InterruptedException ex) {
        }

        // block here til waveform data thread is done
        //System.out.println(" Waiting for waveform db data");
        try {
           wlistThread.join();
        }
        catch (InterruptedException ex) {
        }


// EXAMPLE2 progress bar monitor
        //System.out.println("Created a solution the channelList and the waveformList, creating magnitude task ...");
        final MonitorableMcaTask mcaTask = 
            new MonitorableMcaTask("MCA_TEST", new JiggleMCA("MCA.properties", channelList)) {
                public void finished() {
                    //McaProgressTester.magnitude = (Magnitude) getTaskResult();
                    //System.out.println("Finished mcaMag task: " + McaProgressTester.magnitude.toString());
                    System.out.println(Magnitude.getNeatStringHeader());
                    System.out.println(jiggleMCA.getSummaryMagnitude().toNeatString());
                }
            };
        mcaTask.setThreadGroup(jiggleThreadGroup);
        mcaTask.setThreadName("MCA");
        mcaTask.setSolutionData(sol, waveList);
        mcaTask.setProgressTimerDelay(1000);

        //System.out.println("Created a solution the channelList and the waveformList, creating task dialog ...");
        TaskMonitorButtonBoxDialog mcaDialog = new TaskMonitorButtonBoxDialog();
        mcaDialog.setTask(mcaTask);
        mcaDialog.setProgressMeterVisible(true);
        mcaDialog.setLocation(50,100);
        TaskCompletedListener tcListener =
             new TaskCompletedListener() { 
                 public void taskCompleted(TaskCompletedEvent taskEvent) {
                     //System.out.println("Listener invoked mag: " + ((Magnitude) mcaTask.getTaskResult()).toString() + "\n");
                     // System.out.println("MAIN: threads running: " + jiggleThreadGroup.activeCount());
                     // jiggleThreadGroup.list(); // DEBUG
                     jiggleThreadGroup.interrupt();
                     System.out.println("Exit MCA processing at: " + new Date(System.currentTimeMillis()).toString());
                 }
             };
        mcaDialog.addTaskCompletedListener(tcListener);
        System.out.println("Starting mca calculation task ...");
        final JButton exitButton = new JButton("Exit");
        exitButton.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                System.out.flush();
                Dialog dialog = (Dialog) exitButton.getRootPane().getParent();
                dialog.setVisible(false);
                dialog.dispose();
                dataSource.close();
                System.exit(0);
            }
        });
        mcaDialog.getContentPane().add(exitButton);
        mcaDialog.pack();
        mcaDialog.startTask();

        } // all of main is in try
        catch (Exception ex) { 
            ex.printStackTrace();
            dataSource.close();
            System.exit(0);
        }
    }
}
