package org.trinet.util.graphics.task;
/** 
  * Implemented by classes performing an updatable progress monitorable task.
  * Usually in the context of a GUI background thread.
  * @see AbstractMonitorableTask
  * @see TaskThreadWorker
*/
public interface ProgressMonitorableTaskIF extends ProgressMonitorableIF {
    String getTaskName();
    void setTaskName(String name);

    String getProgressMessage();
    void setProgressMessage(String message);

    int getMinProgressValue();
    void setMinProgressValue(int value);

    int getMaxProgressValue();
    void setMaxProgressValue(int value);

    int getCurrentProgressValue();
    void setCurrentProgressValue(int value);

    int getProgressTimerDelay() ;
    void setProgressTimerDelay(int millisecs);

    Object getTaskResult();

    boolean isTaskComplete();

    void stopTask();
    void startTask();
    Object doTask();

    // for future implementation ?
    //void suspendTask();
    //void resumeTask();
}

