package org.trinet.util.graphics.task;
import java.awt.*;

/** An extension of TaskMonitorProgressBarPanel with a button component
  * enabled for controlling the starting, stopping, or canceling of
  * the AbstractMonitorableTask.
*/
public abstract class AbstractTaskMonitorButtonBoxPanel extends TaskMonitorProgressBarPanel {

    /** Container for buttons controlling task. */
    protected Container buttonControls; // e.g. Box, JComponent, Window, ScrollPane

    public AbstractTaskMonitorButtonBoxPanel (AbstractMonitorableTask task) {
        super(task);
    }

    protected void initPanel() {
        initProgressComponent();
        initButtonControlComponent();
        initPanelLayout();
        initTimer();
    }

    protected void initButtonControlComponent() {
        if (buttonControls != null) remove(buttonControls);
        buttonControls = createControlButtonComponent();
    }

    protected void resetProgressGraphics() {
        resetProgressComponent();
        resetControlButtons();
    }

    protected abstract void initPanelLayout() ;
    protected abstract Container createControlButtonComponent() ;
    protected abstract void resetControlButtons() ;
}
