
//Title:        Your Product Name
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.awt.event.*;

import javax.swing.border.*;

import org.trinet.jasi.*;
import org.trinet.jasi.coda.*;
import org.trinet.util.*;
import org.trinet.util.graphics.ColorList;

/**
* A text JList of JasiReadings (Phase, Amp, Coda) that is selectable so that by
* clicking on a text line the channel is selected via the MasterView's masterWFWindowModel.
*
* This component does NOT listen to the masterWFWindowModel itself, :. doesn't
* change selection to match selections made in other views.
*/
public class SelectableReadingList extends JPanel {

     Solution sol = null;

     JasiReadingList readingList;
     /** The subset of readingList that is visible. Virtually deleted events should not
     * be shown. */
     JasiReadingList visibleList;

     String header = "";

     JasiReadingListListener jasiReadingListListener = new JasiReadingListListener();

     JButton recalcButton;
     /** Optional actionListener that recalculates the summary value for these readings. */
     ActionListener recalcListener;

     // MasterView is needed for the models
     MasterView mv;

     BorderLayout borderLayout1 = new BorderLayout();
     BorderLayout borderLayout2 = new BorderLayout();
     JPanel topPanel = new JPanel();
     JTextArea summaryTextArea   = new JTextArea();
     JScrollPane scroller = new JScrollPane();

     JList jlist = new JList();

     // flag to know if a popup is available
//     boolean hasPopup = false;

     // type of list we are showing
     int type;

     public static final int Phases = 0;
     public static final int Amps   = 1;
     public static final int Codas  = 2;

      //                    type         face      size
     Font font = new Font("Monospaced", Font.PLAIN, 12);
     Font fontBold = new Font("Monospaced", Font.BOLD, 12);

     Color summaryBackground = Color.yellow;
     Color headerBackground = Color.gray;
     Color selectedBackgroundColor =  Color.lightGray;

     public SelectableReadingList() {

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }

        this.setFont(font);

        jlist.setFont(font);

        jlist.setCellRenderer(new SelectableListCellRenderer());
        jlist.setModel(new DefaultListModel());
//      jlist.setSelectionBackground(jlist.getBackground());   // white??
        jlist.setSelectionBackground(selectedBackgroundColor);


        // add listener to the JList (rather than the model)
        jlist.addListSelectionListener(new SelectionListener());

        summaryTextArea.setFont(fontBold);
        summaryTextArea.setLineWrap(true);
        summaryTextArea.setBackground(summaryBackground);
        summaryTextArea.setEditable(false);
        summaryTextArea.setBorder(BorderFactory.createRaisedBevelBorder());

     }

     /** Using 'type', construct the approriate type of reading component. */
     public SelectableReadingList(MasterView mv, Solution solution, int type) {

            this();

            this.type = type;

            this.mv = mv;

            JasiReadingList readings;

            if (type == Phases) {
               readings = solution.phaseList;
            } else if (type == Amps) {
               readings = solution.ampList;
            } else if (type == Codas){
               readings = solution.codaList;
            } else {
               return;
            }

            setHeader(type);
            setSolution(solution, type);
            setReadingList(readings);  // do first so we can tell if phases, amp, or codas

            setSelectedFromWFViewModel();
    }

     public SelectableReadingList(MasterView mv,
                                  Solution solution,
                                  JasiReadingList readings) {
            this();

            this.mv = mv;

            if (readings instanceof PhaseList) {
              type = Phases;
            } else if (readings instanceof AmpList) {
              type = Amps;
            } else if (readings instanceof CodaList) {
              type = Codas;
            }

            setHeader(type);
            setSolution(solution, type);
            setReadingList(readings);  // do first so we can tell if phases, amp, or codas
            setSelectedFromWFViewModel();
     }

    /** Set the reading list header to the right type. */
    protected void setHeader (int type) {

            if (type == Phases) {
               header = Phase.getNeatStringHeader();
            } else if (type == Amps) {
               header = Amplitude.getNeatStringHeader();
            } else if (type == Codas){
               header = Coda.getNeatStringHeader();
            } else {
               return;
            }
    }


     public void setSolution(Solution solution, int type) {

            sol = solution;

            if (sol == null)  {
               summaryTextArea.setText(""); // clear any old stuff
            } else {
               String str = "";
               // show summary location
               if (type == Phases) {
                 str += sol.toNeatString() +
                        "\n" + sol.getErrorStringHeader() +
                        "\n" + sol.toErrorString();
               // show summary mag
               } else {                                     // must be amps or codas
                 str += sol.magnitude.getNeatStringHeader() +
                        "\n" + sol.magnitude.toNeatString();
               }

               summaryTextArea.setText(str);
            }

     }

     public void setReadingList (JasiReadingList list) {

          if (list != null)  {

            if (readingList != list) {        // a change
              // remove listener from old list so reference doesn't dangle
              if (readingList != null)
                  readingList.removeChangeListener(jasiReadingListListener);

              readingList = list;

              // add THIS as a listener to the new list
              readingList.addChangeListener(jasiReadingListListener);

            }

              //readingList.timeSort();            // sort readings by time
              readingList.distanceSort(sol.getLatLonZ());

              // set the column header to the neatHeader
              JLabel hLabel = new JLabel(header);
              hLabel.setFont(getFont());
              scroller.setColumnHeaderView(hLabel);

         // filter out unassoc or deleted readings
              visibleList = readingList.getAssociatedWithSol(sol);
              jlist.setListData(visibleList.toArray());

       }
     }

     public void setSelectedFromWFViewModel() {
              // get selected channel from master model
              if (mv != null &&  mv.masterWFViewModel.get() != null) {

                  Channel selChan = mv.masterWFViewModel.get().getChannelObj();

                  // will find *1st* occurance of Chan in the JList
                  int newIndex = visibleList.getIndexOf(selChan);

                  if (newIndex > 0 && newIndex < (jlist.getModel().getSize()-1))
                                jlist.setSelectedIndex(newIndex);
               }
     }

     /** If an "recalc" Listener is added to this component it is wired to a [Recalc]
     * button. We assume the action/button will recalc the summary mag.
     * The ActionListener is defined by the caller and passed to this class. */

     /* Alternatively we COULD recalc everytime there's a change. */
     public void addRecalcListener (ActionListener listener) {

         recalcListener = listener;

         if (recalcButton == null) {
             recalcButton = new JButton("Recalc");
             recalcButton.setToolTipText("Recalculate the summary magnitude");
             recalcButton.setAlignmentY(CENTER_ALIGNMENT);
             recalcButton.setHorizontalTextPosition(AbstractButton.CENTER);
             recalcButton.setVerticalTextPosition(AbstractButton.BOTTOM);

             topPanel.add(recalcButton, BorderLayout.EAST);
         }
         recalcButton.addActionListener(recalcListener);
     }
     /** Remove listeners from other components so we are not a memory leak. */
     public void destroy() {
        if (readingList != null)
                readingList.removeChangeListener(jasiReadingListListener);
     }

     /*
       Make the GUI - generated with JBuilder
     */
     private void jbInit() throws Exception {
          this.setLayout(borderLayout1);
          topPanel.setLayout(borderLayout2);

          jlist.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

          jlist.addMouseListener(new MouseAdapter() {

               public void mousePressed(MouseEvent e) {

                 int mods = e.getModifiers();
                 // popup menu on right-click
                 if (e.isPopupTrigger() ||
                     (mods & MouseEvent.BUTTON3_MASK) != 0)

                     // only if something is selected
                     if (getSelectedReading() != null) makePopup(e.getPoint());

               }
          });

          jlist.addKeyListener(new java.awt.event.KeyAdapter() {

               // event is fired on both mouse down and release so don't act until release
               public void keyReleased(KeyEvent e) {
                 int key = e.getKeyCode();
                 // respond to [DEL] key
                 if (e.getKeyCode() == KeyEvent.VK_DELETE) {
                     deleteCurrentReading();
                 }
               }
          });
          topPanel.add(summaryTextArea, BorderLayout.CENTER);
          this.add(topPanel, BorderLayout.NORTH);
          this.add(scroller, BorderLayout.CENTER);
          scroller.getViewport().add(jlist, null);

     }

     /**
     * Return the reading at this index in the list.
     * Returns null if no readings in list, or index is out-of-bounds.
     */
     public JasiReading getReading (int index) {
       if (visibleList.isEmpty() || index < 0 || index > visibleList.size()) return null;
       return  (JasiReading) visibleList.get(index);
     }

     /** Return the currently selected reading. Returns null if no readings in list
     or none selected.*/
     public JasiReading getSelectedReading () {

       return (JasiReading) jlist.getSelectedValue();

     }

     /** Delete the currently selected reading */
     protected void deleteCurrentReading() {

         JasiReading jreading = (JasiReading) jlist.getSelectedValue();
         int oldIndex = jlist.getSelectedIndex();

         readingList.delete(jreading);     // This fires change event

         // should keep "cursor" in same place but not fall off end
         int newIndex = Math.min(oldIndex, jlist.getModel().getSize()-1);
         if (newIndex > -1) jlist.setSelectedIndex(newIndex);
     }

////////////////////////////////////////////////////////////////////////////////////
/** React to a changes in the jasi reading list. Changes (delete, add, etc.)
* may come from inside or outside this class. */
class JasiReadingListListener implements ChangeListener {

  public void stateChanged (ChangeEvent evt) {
        // just redo the list if ANYTHING changed in the readingList
        setReadingList(readingList);                  // redo the whole thing
     }
/*
       int index = 0;

        int oldIndex = jlist.getSelectedIndex();

        Channel selChan = mv.masterWFViewModel.get().getChannel();
        int newIndex = visibleList.getIndexOf(selChan);

     // if no match in list this keeps the "pointer" at the same position in the list when
     // an item is deleted
        if (newIndex > -1) {
          index = newIndex;
        } else {
          index = oldIndex;
        }

// just redo the list if ANYTHING changed in the readingList
        setReadingList(readingList);                  // redo the whole thing

        if (hasFocus()) {

          // if you deleted the last thing in the list move up one
          int maxIndex = jlist.getModel().getSize()-1;
          if (index > maxIndex) index = maxIndex;
          System.out.println ("JasiReadingListListener.stateChanged hasFocus() idx = "+index);
          // NOTE: this fires an SelectionListenerEvent
          jlist.setSelectedIndex(index);
        }

//             System.out.println ("JasiReadingListListener: "+index +"\n"+evt.toString());

     }
*/
} // end of JasiReadingListListener

////////////////////////////////////////////////////////////////////////////////////
class SelectionListener implements ListSelectionListener  {

/* The real work is done as a Runnable to guarantee that, even if called from another
thread, the selection action happens in the
 Event-Dispatch thread, and does not cause thread dead-locks. */
      Runnable runnable;

      Channel chan;
      double centerTime;

      WFViewList wfvList;

// /////////////////////////////////////////////////////////////////////////////////
      public SelectionListener() {
        super();

        // insure this happens in event-dispatch thread because it
        // fires events that do graphics updates
        runnable = new Runnable() {
          public void run() {

             WFView wfv = wfvList.get(chan);

             if (wfv != null) {
               // select this WFView
               mv.masterWFViewModel.set(wfv);
               mv.masterWFWindowModel.setFullAmp();       // set amp scale to full scale
               mv.masterWFWindowModel.setCenterTime(centerTime);
             }
          }
        };
      }
 /** React to a JList selection. */
      public void valueChanged( ListSelectionEvent evt) {

//      System.out.println("SelectionListener: "+ evt.toString());

             if (evt.getValueIsAdjusting()) return;   // don't react until mouseReleased

             JList list = (JList) evt.getSource();

             JasiReading jreading = (JasiReading) list.getSelectedValue();

             if ((jreading != null)) {

                chan = jreading.getChannelObj();
                centerTime = jreading.getDateTime().getEpochSeconds();

                wfvList = mv.wfvList;

                // insure this happens in event-dispatch thread because it
                // fires events that do graphics updates
//                if (list.hasFocus())
                     SwingUtilities.invokeLater(runnable);

             }
      }
} // end of SelectionListener
////////////////////////////////////////////////////////////////////////////////////

/** React to change in selected WFView from outside. Highlight the reading if
* there is one. */
/*
class  WFViewModelChangeListener implements ChangeListener {

   public void  valueChanged( ListSelectionEvent evt) {

   }
}
*/
/** Make a renderer to make "bad" amp red. */
class SelectableListCellRenderer extends JLabel implements ListCellRenderer {

   private Border lineBorder  = BorderFactory.createLineBorder(Color.blue, 1);
   private Border emptyBorder = BorderFactory.createEmptyBorder(1,1,1,1);

   double redThreshold    = 0.5;
   double yellowThreshold = 0.25;

   Color goodColor = Color.black;
   Color warnColor = ColorList.burntOrange; // standard orange is too light
   Color badColor  = Color.red;
   Color notUsedColor  = Color.blue;

/** Set the values of the warning levels. */
   public void setThresholds(double yellowValue, double redValue) {
      redThreshold = redValue;
      yellowThreshold =  yellowValue;
   }
/** Set the colors of the different warning levels. */
   public void setColors (Color good, Color warn, Color bad, Color notUsed) {
    goodColor = good;
    warnColor = warn;
    badColor  = bad;
    notUsedColor = notUsed;
   }

/** Render the component */
   public Component getListCellRendererComponent
          (JList list, Object obj, int index, boolean isSelected, boolean hasFocus) {

          if (!(obj instanceof JasiReading)) {
             setText("No Data...");
             return this;
          }

          JasiReading jreading = (JasiReading) obj;

          setText(jreading.toNeatString());
          setFont(list.getFont());
          // Every JasiReading can return a "warning level" from 0.0 - 1.0
          // indicating its "goodness"
    if (!jreading.wasUsed()) {
      setForeground(notUsedColor);
          } else if (jreading.getWarningLevel() > redThreshold) {
             setForeground(badColor);
          } else if (jreading.getWarningLevel() > yellowThreshold) {
             setForeground(warnColor);
          } else {
             setForeground(goodColor);
          }

          // highlight selected row
          // setBackground DOES NOT WORK!
          if (isSelected) {
//             setBackground (list.getSelectionBackground());
               setBackground (selectedBackgroundColor);

//         setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
//         setForeground(isSelected ? Color.white : Color.black);

//          if (hasFocus) {
             setBorder(lineBorder);
          } else {
             setBorder(emptyBorder);
//          } else {
//             setBackground (list.getBackground());
          }
          return this;
   }
}


    /** Create the popup menu that is activated by a right mouse click */
    public void makePopup (Point point) {

       PopupListener popupListener = new PopupListener();
       JMenuItem mi;
       JMenu submenu;

       JPopupMenu popup = new JPopupMenu();

       mi = popup.add(new JMenuItem("Delete"));
       mi.addActionListener(popupListener);

       mi = popup.add(new JMenuItem("Strip more distance"));
       mi.addActionListener(popupListener);

//       mi = popup.add(new JMenuItem("Zero-weight"));
//       mi.addActionListener(popupListener);

       if (recalcListener != null) {
          popup.addSeparator();

          mi = popup.add(new JMenuItem("RECALC"));
          mi.addActionListener(popupListener);
       }

       popup.addSeparator();

       mi = popup.add(new JMenuItem("Close Popup"));
       mi.addActionListener(popupListener);

       popup.show (this, point.x, point.y);

    }
// Inner class to handle popup menu events
    public class PopupListener implements ActionListener {

      public void actionPerformed (ActionEvent evt) {

        JComponent src = (JComponent) evt.getSource(); //the popup menu

        String action = evt.getActionCommand();

        int index = jlist.getSelectedIndex();

        if (index > -1) {
         if (action.equals("Delete")) {

           // delete via the list to kick any listeners, including US!
//          readingList.delete(jlist.getSelectedValue());
            deleteCurrentReading();
 //        } else if (action == "Zero-weight") {

         } else if (action.equals("RECALC")) {

            recalcListener.actionPerformed(new ActionEvent(this, 0, "Recalc"));

         } else if (action.equals("Strip more distant")) {

            JasiReading jreading = getSelectedReading();

            if (jreading == null) return;

            double cutoff = jreading.getDistance();

            if (type == Phases) {
              mv.stripPhasesByDistance(cutoff, mv.getSelectedSolution());
            } else if (type == Amps) {
              mv.stripAmpsByDistance(cutoff, mv.getSelectedSolution());
            } else if (type == Codas) {
              mv.stripCodasByDistance(cutoff, mv.getSelectedSolution());
            }

         } else if (action == "Close Popup") {
      // noop
         }
        }

      }

    }


// //////////////////////////////////////////////////////////////////////////////
     public static void main(String args[]){

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
          });

  int evid;

  if (args.length <= 0) {
    System.out.println ("Usage: java this-thing [evid])");

    evid = 9635181;

    System.out.println ("Using evid "+ evid+" as a test...");

  } else {

    Integer val = Integer.valueOf(args[0]);    // convert arg String to 'double'
    evid = (int) val.intValue();
  }
     BenchMark bm = new BenchMark();

        System.out.println ("Making connection...");
  DataSource init = new TestDataSource();  // make connection
  init.setWriteBackEnabled(true);
     /*
     System.out.println ("Reading master channel list...");
     MasterChannelList.set(ChannelList.readCurrentList());
     */

     System.out.println ("Getting data for evid = "+evid);

     MasterView mv = new MasterView();
     //org.trinet.jiggle.MasterView mv = new org.trinet.jiggle.MasterView();

     //mv.setWaveFormLoadMode(mv.LoadNone);
     mv.setWaveFormLoadMode(mv.Cache);
     mv.setCacheSize(50, 50);

     mv.setLoadChannelData(true);
     mv.setAlignmentMode(MasterView.AlignOnTime);

     mv.defineByDataSource(evid);

  Solution sol    = mv.solList.getSelected();

     mv.distanceSort(sol);

     System.out.println ("Number of phases = "+sol.getPhaseList().size());

     bm.print("BenchMark: event parameters loaded ");
     bm.reset();

     final WFScroller wfScroller = new WFScroller(mv, true) ;	    // make scroller
     //final WFScroller wfScroller = new WFScroller(mv, false) ;	    // make scroller

     mv.masterWFViewModel.selectFirst(mv.wfvList);

        // make an empth Zoomable panel
     ZoomPanel zpanel = new ZoomPanel(mv);

        wfScroller.setMinimumSize(new Dimension(300, 100) );
  // make a split pane with the zpanel and wfScroller
     JSplitPane split =
      new JSplitPane(JSplitPane.VERTICAL_SPLIT,
         false,       // don't repaint until resizing is done
         zpanel,      // top component
         wfScroller); // bottom component


        //frame.getContentPane().add(list);
        SelectableReadingList plist = new SelectableReadingList(mv, sol, sol.phaseList);
        SelectableReadingList alist = new SelectableReadingList(mv, sol, sol.ampList);
        SelectableReadingList clist = new SelectableReadingList(mv, sol, sol.codaList);

        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("Phases", plist);
        tabPane.addTab("Amplitudes", alist);
        tabPane.addTab("Codas", clist);

//        frame.getContentPane().add(wfScroller, BorderLayout.CENTER);
        frame.getContentPane().add(split, BorderLayout.CENTER);
        frame.getContentPane().add(tabPane, BorderLayout.SOUTH);

        frame.pack();
        frame.setVisible(true);

    }
}
