package org.trinet.jiggle;

/**
 * PickingPanel.java
 *
 *
 * Created: Mon Nov  8 17:02:50 1999
 *
 * @author Doug Given
 * @version
 */
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import java.text.*;
import javax.swing.border.*;
import javax.swing.event.*;

import org.trinet.jasi.*;

/**
 * A PickingPanel allows all the function of a ZoomPanel plus supports phase
 * picking.
 */
public class PickingPanel extends ZoomPanel {

    /** The master view of what's in the GUI */
    //    public MasterView mv;

    /** The popup menu sets it's postion relative to a component. So
     * We use ourself. Can't use 'this' directly because it is passed
     * in a button listener inner class and 'this' means the listener. */
    Component popupReference = this;

    boolean debug = false;

   /**
     * Constructor
     */
    public PickingPanel() {
    }

   /**
     * Constructor with placeholder string. This is used to create a valid
     * PickingPanel when there is no data loaded yet.  */
    public PickingPanel(String str) {
	add(new JLabel(str));
    }

    /**
     * Constructor
     */
    public PickingPanel(MasterView masterView) {

	//	super (masterView);
	mv = masterView;
	buildPanel();
    }
/**
 * Build the panel
 */
  protected void buildPanel() {

    setOpaque(true);

    setLayout( new BorderLayout() );

// <> put scroller in center
    add("Center", makeScrollZoom());

// <> create the button panels and put at bottom

    JPanel bottom = new JPanel();
    bottom.setLayout(new BoxLayout(bottom, BoxLayout.Y_AXIS));

    bottom.add(makeControlPanel());
    bottom.add(makeButtonPanel());
    add("South", bottom);
    add("East", makeArrowPanel());

// Listen MVC for newly selected WFViews
    mv.masterWFViewModel.addChangeListener(new WFViewListener());
} // end of builder

    /**
     * make the scrolling zooming panel.
     */
/*    protected JScrollPane makeScrollZoom () {
//      return makeScrollZoom(new PickableWFPanel (scrollZoom, mv));
      return makeScrollZoom(new PickableWFPanel(mv));
    }
 */
    protected JScrollPane makeScrollZoom () {

       	zwfp = new PickableWFPanel (makeScrollZoom1(), mv);
          return setupZoomableWFPanel();
    }
    /**
     * make the scrolling zooming panel.
     */
/*    protected JScrollPane makeScrollZoom () {

// <> create the ScrollPane
	JScrollPane scrollZoom = new JScrollPane(
			 ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
			 ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);

	// Replace the default viewport of the scrollPane with ours
	scrollZoom.setViewport(vport);
	vport.setBackingStoreEnabled(true);   // speeds scrolling

	// make a panel for the waveform
	// THIS MUST BE DONE AFTER THE 'ScrollZoom.setViewport(vport)' ABOVE

     // This is the only difference in this method compared to ZoomPanel
     // It inserts a PickableWFPanel to allow the phase pick popup.
/////	zwfp = new PickableWFPanel (scrollZoom, mv);
	zwfp.setCursorLocModel(cursorLocModel);

	// set scrolling time scale in column header
     TimeColumnHeader tch = new TimeColumnHeader(zwfp);
	scrollZoom.setColumnHeaderView(tch);
//     scrollZoom.setColumnHeader(createViewport());
//     scrollZoom.getColumnHeader().setView(tch);

	// ** Had turned this off because of recursion problem with scroller
     if (scrollable) {	// control some of the scroll pane's behavior

     	// set scrolling increments
	    JScrollBar vBar = scrollZoom.getVerticalScrollBar();
	    JScrollBar hBar = scrollZoom.getHorizontalScrollBar();

//.//	    vBar.setUnitIncrement(10); // jump 10 pixel each mouse click on arrow
//.//	    hBar.setUnitIncrement(10);

	// Add same adjustment listener to both
//        ScrollListener scrollListener = new ScrollListener();
        vBar.addAdjustmentListener(new VerticalScrollListener());
        hBar.addAdjustmentListener(new HorizontalScrollListener());

     }

     	return scrollZoom;

    }
*/

// Make the button panel
    protected Box makePickButtonPanel () {

        Box box = Box.createHorizontalBox();

        box.add(Box.createGlue());

        JButton btn = addButton(box, new JButton("DEL"), "Delete the nearest phase pick");
        btn.addActionListener (new DelButtonHandler() );
        box.add(Box.createHorizontalStrut(5));

        btn = addButton(box, new JButton("PICK"), "Make a new pick here");
        btn.addActionListener (new PickButtonHandler() );
        box.add(Box.createHorizontalStrut(5));

      return box;
    }

// Make the button panel *** NEW ***
    protected Box makeControlPanel ()
    {
        Box box = Box.createHorizontalBox();

        // The staLabel has file scope because it is changed by another method
        staLabel = new JLabel("Station Info here...");
        staLabel.setBackground(Color.black);
        staLabel.setForeground(Color.blue);
        box.add(staLabel);

        box.add(Box.createGlue());
        box.add(makePickButtonPanel());
        box.add(Box.createGlue());

        // cursor position labels
        CursorLocPanel cursorPanel = new CursorLocPanel(cursorLocModel);
        box.add(cursorPanel);


      return box;
    }

/*-----------------------------------------------------------------
 *  method to stream line adding of buttons, with tooltips
 */
/*     void addButton (Container box, JButton btn, String tip)
    {
      btn.addActionListener (new ButtonHandler() );
      btn.setToolTipText(tip);

      box.add(btn);
    }
*/
/*     void addButton (Box box, JButton btn, String tip)
    {
      btn.addActionListener (new ButtonHandler() );
      btn.setToolTipText(tip);

      box.add(btn);
    } */
//-----------------------------------------------------------------
// Event handling
//-----------------------------------------------------------------

// Handle button and menu events
class DelButtonHandler implements ActionListener {

    public void actionPerformed (ActionEvent evt) {

	double pickTime = mv.masterWFWindowModel.getTimeSpan().getCenter();

	// Had some sort of scope problem with mv from the PickingPanel.
	// It was NOT THE SAME as the current one used by other components!
	//  PickingPanel.mv != zwfp.wfv.mv
	// The PhaseList in the MasterView is needed for the PhaseList MVC
	// interaction to work.

     MasterView mv = zwfp.wfv.mv;

     if (debug) System.out.println ("del");

     Phase delphase = zwfp.wfv.phaseList.getNearestPhase(pickTime, mv.getSelectedSolution());

     // Delete it in Solution's list so listeners know
     mv.getSelectedSolution().deletePhase(delphase);

   }
}

class PickButtonHandler implements ActionListener {

    public void actionPerformed (ActionEvent evt) {

	double pickTime = mv.masterWFWindowModel.getTimeSpan().getCenter();

	// Had some sort of scope problem with mv from the PickingPanel.
	// It was NOT THE SAME as the current one used by other components!
	//  PickingPanel.mv != zwfp.wfv.mv
	// The PhaseList in the MasterView is needed for the PhaseList MVC
	// interaction to work.

     MasterView mv = zwfp.wfv.mv;

     Point xy = new Point(popupReference.getWidth()/2,
				 popupReference.getHeight());

     new PhasePopup(popupReference, zwfp, xy);

     // NOTE: code does not block on the call above!
     if (debug) System.out.println ("PICK");
   }


}

} // PickingPanel
