package org.trinet.jasi;

import java.util.*;
//import org.trinet.jdbc.*;
//import org.trinet.jasi.*;
import org.trinet.util.*;

/**
 * PhaseList.java
 *
 *
 * Created: Fri Nov 19 09:15:08 1999
 *
 * @author Doug Given
 * @version
 */
/*

ArrayList
  ActiveArrayList
                 JasiReadingList
                                 PhaseList
*/
//public class PhaseList extends ArrayList {
public class PhaseList extends JasiReadingList {
    public PhaseList() {

    }

    public PhaseList(Collection col) {
	addAll(col);
    }

   /** Commit ALL deleted phases to underlying DataSource. Note that a deleted
       phase is also unassociated, so you can't commit deleted phases
       selectively by Solution. */
    public boolean commitDeleted()
    {
	Phase ph[] = (Phase[]) getArray();
	for (int i = 0; i<ph.length; i++) {
	    if (ph[i].isDeleted())  ph[i].commit();
	}

     // Should these be removed from the list???

	return true;
    }

   /** Commit changes or delete to underlying DataSource. Note that a
    * unassociated phases can't be selectively committed by Solution since they
    * have none.*/
    public boolean commitUnassociated()
    {
	Phase ph[] = (Phase[]) getArray();
	for (int i = 0; i<ph.length; i++) {
	   if ( !ph[i].isAssociated() )  ph[i].commit();
	}
	return true;
    }
    /**
     * Substitute for ArrayList.get() that casts the returned object as a
     * Phase. (Can't truely overide the get() method because you can't change
     * the return type when you override a method.)  */
    public Phase getPhase(int idx) {
	return (Phase) get(idx);
    }
    /**
     * Convenience method that casts the object array returned by toArray()
     * as an array of type Phase.  */
    public Phase[] getArray() {
	return (Phase[]) toArray(new Phase[0]);
    }

    /** Return a subset of this list containing the JasiObjects that are associated
     * with this solution. If Solution is set to null, unassociated objects will
     * be returned. Virtually deleted objects are never associated. */
    // Override getAssociated() in JasiReadingList because it return a JasiList object
    // and fucks up other code.
    public PhaseList getAssociated(Solution sol) {

	PhaseList newList = new PhaseList();

	Phase ph[] = getArray();

	for (int i = 0; i<ph.length; i++) {
	    if (ph[i].sol == sol && !ph[i].isDeleted() ) {
            newList.add(ph[i]);
         }
	}
	return newList;
    }

    /** Return a subset of this list containing the Phases that are from the
     * given Channel. If Solution is set to null, unassociated phases will
     * be returned.
     *@deprecated: use getAssociated(Channel chan) */

    public PhaseList getAssociatedWithChannel(Channel chan) {

       return getAssociated (chan);
    }
    /** Return a subset of this list containing the Phases that are from the
     * given Channel. If Solution is set to null, unassociated phases will
     * be returned. */

    public PhaseList getAssociated(Channel chan) {

	PhaseList newList = new PhaseList();

	Phase phs[] = (Phase[]) getArray();
	for (int i = 0; i<phs.length; i++) {

	    //	    if (chan.equalsIgnoreCase(phs[i].chanName)) {
	    if (chan.sameAs(phs[i].getChannelObj())) {

		newList.add(phs[i]);
	    }
	}
	return newList;
    }

    /** Null out the association of all phases in the list */
    public void unassociateAll() {
	Phase phs[] = (Phase[]) getArray();
	for (int i = 0; i<phs.length; i++) {
	    phs[i].unassociate();
	}
    }


    // BEGIN DK CODE CHANGE 020403
    /** Null out any location-associated information for this phase. */
    public void clearLocationAttributes()
    {
	Phase phs[] = (Phase[]) getArray();
	for (int i = 0; i<phs.length; i++) {
	    phs[i].clearLocationAttributes();
	}
    }
    // END DK CODE CHANGE 020403


/**
 * If there is a phase in the list of the same type (e.g. "P", "S", etc) for the
 * same Channel, replace its data values with those of this phase.
 * If there is no phase of this type for this channel, add this phase to
 * the list and set the return value to the new phase. */
public Phase addOrReplacePhase(Phase newph) {

    // look for existing phase of same type (P, S, etc.)
    Phase oldph = getPhaseSame(newph);	// require associated with same sol

    if (oldph == null) {	// no original, just add the new one

	add(newph);         // this will fire the change event

	return newph;

    } else {

    // delete the old, notify listeners
     oldph.delete();       // mark phase as deleted
     this.delete(oldph);   // delete from list and notify change listeners

	//oldph.replace(newph);	// replace the old one

     // added the new
     this.add(newph);
     // this is done by add() // fireStateChanged(newph);   // notify change listeners

	return oldph;
    }
}
/**
 * Search the list for a phase with the same Channel and TYPE (P, S, Pg,
 PkP, etc.).  Note that the phases need NOT be associated with the same
 solution. Returns null if no match is found.
@See: getPhaseSame() */
    public Phase getPhaseLike(Phase ph) {

	if (isEmpty()) return null;

	Phase phs[] = (Phase[]) getArray();

	for (int i = 0; i<phs.length; ++i) {	// inc at start
	    // If we remove the isDeleted() test deleted phase rows will be reused.
	    if (!phs[i].isDeleted()) {
		if (ph.isLike(phs[i]) )  return phs[i];
	    }
	}

	return null;
    }
/**
 * Search the list for a phase with the same Channel, TYPE (P, S, Pg, PkP,
 etc.) and associated with the same solution.  Returns null if no match is
 found.
@See: getPhaseSame() */
    public Phase getPhaseSame(Phase ph) {

	if (isEmpty()) return null;

	Phase phs[] = (Phase[]) getArray();

	for (int i = 0; i<phs.length; ++i) {	// inc at start
	    // If we remove the isDeleted() test deleted phase rows will be reused.
	    if (!phs[i].isDeleted()) {
		if (ph.isSame(phs[i]) )  return phs[i];
	    }
	}

	return null;
    }
/**
 * Return the phase nearest to this time that is associated with this solution.
 * Returns null if there are no phases.
 */
    public Phase getNearestPhase(double time, Solution sol) {

     return (Phase) getNearestToTime(time, sol);
    }
/**
 * Return the phase nearest to this time. Returns null if there are no phases.
 */
    public Phase getNearestPhase(double time, Channel chan) {

     return (Phase) getNearestToTime(time, chan);
    }
/**
 * Return the phase nearest to this time. Returns null if there are no phases.
 */
    public Phase getNearestPhase(double time) {

     return (Phase) getNearestToTime(time);
 /*
	if (isEmpty()) return null;

	Phase nearest = null;
	double nearestDiff = Double.MAX_VALUE;
	double diff;

	Phase ph[] = (Phase[]) getArray();
	for (int i = 0; i<ph.length; i++)	// inc at start to skip ph[0]
	{
	    if (!ph[i].isDeleted()) {
		diff = Math.abs(ph[i].getTime() - time);

		if (diff < nearestDiff) {
		    nearestDiff = diff;
		    nearest = ph[i];
		}
	    }
	}

	return nearest;
*/
    }
/**
 * Mark all phases in the list as deleted and unassociated. Returns the number
 * of deleted phases.
 */
    public int deleteAll() {
      int knt = 0;
      Phase ph[] = (Phase[]) getArray();
      for (int i = 0; i < ph.length; i++) {

	    //ph[i].delete(); // this does virtual delete
         delete(ph[i]);   // removes from list and fires events
         knt++;
	}
     return knt;
    }

/**
 * Mark all phases with a residual >= this value (+-secs) as deleted and
 * unassociate. Also removes phases with a null residual.  */
    public void stripByResidual(double val) {

      Phase ph[] = (Phase[]) getArray();

      for (int i = 0; i < ph.length; i++) {

	    if ( ph[i].residual.isNull() ||
		 (Math.abs(ph[i].residual.doubleValue()) >= val)) {
		    //ph[i].unassociate();
		    ph[i].delete();
	    }
	}

    }

 /**
 * Mark all phases with a distance > this value (km) as deleted and
 * unassociate. Also removes phases with a null dist.  */
    public void stripByDistance(double val)  {

      Phase ph[] = (Phase[]) getArray();

      for (int i = 0; i < ph.length; i++)
	{
	    if ( ph[i].chan.dist.isNull() ||
		 (ph[i].getDistance() >= val)) {
		    ph[i].delete();
	    }
	}

    }

    /**
     * Dump phase list, for debugging */
    public void dump() {
	Phase phs[] = (Phase[]) getArray();
	for (int i = 0; i<phs.length; i++) {	// inc at start
	    System.out.println (phs[i].toString());
	}

    }


/**
 * Dump the entire list to the screen in Hypoinverse archive format. For
 * debugging.  */
    public String dumpToArcString()
    {
      String str = "";

      Phase ph[] = (Phase[]) getArray();

      for (int i = 0; i < ph.length; i++) {
      // weed out virtually deleted phases
          if (!ph[i].isDeleted())
	        str += HypoFormat.toArchiveString(ph[i]) +"\n" ;
	}
      return str;

    }

/**
 * Main for testing
 */

    public static void main (String args[])
    {
	int evid;

	if (args.length <= 0)	// no args
	{

	  evid = 9506369;

	  System.out.println ("Using evid "+ evid+" as a test...");

	} else {

	  Integer val = Integer.valueOf(args[0]);    // convert arg String to 'double'
	  evid = (int) val.intValue();
	}

        System.out.println ("Making connection...");
	DataSource ds = new TestDataSource();
	// NOTE: this demonstrates making a static Channel list.
	//        System.out.println ("Reading in station list...");
	//	Channel.setList (Channel.getAllList());

        System.out.println ("Getting phases  for "+evid);

//	ArrayList phList = (ArrayList) Phase.create().getBySolution(evid);
 	ArrayList phList = (ArrayList) Phase.create().getBySolution(evid);

	PhaseList phaseList = new PhaseList(phList);

     Phase ph[] = phaseList.getArray();

     System.out.println ("Number of phases = "+ ph.length);

	System.out.println ("Number of phases = "+ phaseList.size());

	phaseList.dump();
    }
} // PhaseList
