package org.trinet.jasi;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Frame1 extends JFrame {
     BorderLayout borderLayout1 = new BorderLayout();
     JPanel jPanel1 = new JPanel();
     JScrollPane scrollPane = new JScrollPane();
     JTextArea textArea = new JTextArea();
     JLabel label1 = new JLabel();
     JTextField nameField = new JTextField();

     //Construct the frame
  public Frame1() {
          enableEvents(AWTEvent.WINDOW_EVENT_MASK);
          try  {
               jbInit();
          }
          catch(Exception e) {
               e.printStackTrace();
          }
        pack();
        setVisible(true);

             }

     //Component initialization
  private void jbInit() throws Exception  {
          this.getContentPane().setLayout(borderLayout1);
          this.setSize(new Dimension(531, 359));
          this.setTitle("Dump Channel Cache File");
          textArea.setText("jTextArea1");
          label1.setText("Cache Filename: ");
          nameField.setPreferredSize(new Dimension(350, 21));
          nameField.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    nameField_actionPerformed(e);
               }
          });

          nameField.setText(ChannelList.getCacheFilename());
          this.getContentPane().add(jPanel1, BorderLayout.NORTH);
          jPanel1.add(label1, null);
          jPanel1.add(nameField, null);
          this.getContentPane().add(scrollPane, BorderLayout.CENTER);
          scrollPane.getViewport().add(textArea, null);
     }

     //Overridden so we can exit on System Close
  protected void processWindowEvent(WindowEvent e) {
          super.processWindowEvent(e);
          if(e.getID() == WindowEvent.WINDOW_CLOSING) {
               System.exit(0);
          }
     }

     void nameField_actionPerformed(ActionEvent e) {

          if (e.getSource() instanceof JTextField) {
          JTextField field = (JTextField) e.getSource();
          String filename =  field.getText();

          String str = "Reading "+ filename +"...";
          textArea.setText(str);

          ChannelList chanList = ChannelList.readFromCache(filename);
          if (chanList == null || chanList.isEmpty())   {
             str = "Read failed.";
          } else {

             str = chanList.toDumpString();
          }
          textArea.setText(str);
       }
     }

     // Doesn't seem to work!
     
     public static void main(String s[]) 
    {

/*        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
        */
        new Frame1();
//        frame.pack();
//        frame.setVisible(true);

    }

     }
