// *** PACKAGE NAME *** \
package org.trinet.jasi.EW.SQL;


// *** IMPORTS *** \
import java.util.*;
import java.sql.Connection;
import java.sql.SQLException;
import org.trinet.jasi.EW.EWPhase;


/**
 * <!-- Class Description>
 *
 *
 * Created:  2002/08/28
 *
 * @author   ew_oci2java Tool / DK
 * @version  0.99
 **/

public class CreateArrivalStatement extends EWSQLStatement
{

  // *** CLASS ATTRIBUTES *** \

  // *** CONSTRUCTORS *** \
  public CreateArrivalStatement()
  {

    sSQLStatement = new String("Begin Create_Arrival(OUT_idOP => :OUT_idOP, OUT_idPick => :OUT_idPick, IN_idOrigin => :IN_idOrigin, IN_idPick => :IN_idPick, IN_sCalcPhase => :IN_sCalcPhase, IN_tCalcPhase => :IN_tCalcPhase, IN_dWeight => :IN_dWeight, IN_dDist => :IN_dDist, IN_dAzm => :IN_dAzm, IN_dTakeoff => :IN_dTakeoff, IN_sObsPhase => :IN_sObsPhase, IN_tObsPhase => :IN_tObsPhase, IN_sExtPickTabName => :IN_sExtPickTabName, IN_xidExternal => :IN_xidExternal, IN_idChan => :IN_idChan, IN_cMotion => :IN_cMotion, IN_cOnset => :IN_cOnset, IN_tResPick => :IN_tResPick, IN_dSigma => :IN_dSigma); End;");

    bIsQuery = false;
    init();
  }


  public CreateArrivalStatement(Connection IN_conn)
  {
    this();
    SetConnection(IN_conn);
  }


  // *** CLASS METHODS *** \

  protected boolean SetInputParams(Object obj)
  {

    EWPhase objEWPhase = (EWPhase)obj;

    try
    {
      cs.setLong(   3, objEWPhase.idOrigin);
      cs.setLong(   4, objEWPhase.idPick);
      cs.setString( 5, objEWPhase.sCalcPhase);
      cs.setDouble( 6, objEWPhase.tCalcPhase);
      cs.setDouble( 7, objEWPhase.dWeight);
      cs.setDouble( 8, objEWPhase.dDist);
      cs.setDouble( 9, objEWPhase.dAzm);
      cs.setDouble(10, objEWPhase.dTakeoff);
      cs.setString(11, objEWPhase.sPhase); //sObsPhase
      cs.setDouble(12, objEWPhase.tPhase); //tObsPhase
      cs.setString(13, objEWPhase.sSource); //sExtPickTabName
      cs.setString(14, objEWPhase.sSourcePickID);  //xidExternal
      cs.setLong(  15, objEWPhase.idChan);
      cs.setString(16, objEWPhase.cMotion);
      cs.setString(17, objEWPhase.cOnset);
      cs.setDouble(18, objEWPhase.tResPick);
      cs.setDouble(19, objEWPhase.dSigma);
    }
    catch (SQLException ex)
    {
      System.err.println("Exception in CreateArrivalStatement:SetInputParams()");
      System.err.println(ex);
      ex.printStackTrace();
      return(false);
    }

    return(true);
  }   // end CreateArrivalStatement::SetInputParams()


  protected boolean RegisterOutputParams()
  {
    try
    {
      cs.registerOutParameter(1, java.sql.Types.BIGINT);
      cs.registerOutParameter(2, java.sql.Types.BIGINT);
    }
    catch (SQLException ex)
    {
      System.err.println("Exception in CreateArrivalStatement:RegisterOutputParams()");
      System.err.println(ex);
      ex.printStackTrace();
      return(false);
    }
    return(true);
  }  // end CreateArrivalStatement:RegisterOutputParams()


  protected boolean RetrieveOutputParams(Object obj)
  {
    EWPhase objEWPhase = (EWPhase)obj;

    try
    {
      objEWPhase.idOriginPick=cs.getLong(1);     // DK was idOP
      objEWPhase.idPick=cs.getLong(2);
    }
    catch (SQLException ex)
    {
      System.err.println("Exception in CreateArrivalStatement:RetrieveOutputParams()");
      System.err.println(ex);
      ex.printStackTrace();
      return(false);
    }

    return(true);
  }   // end CreateArrivalStatement::RetrieveOutputParams()


} // end class CreateArrivalStatement


//             <EOF>
