package org.trinet.util.graphics.task;
import java.awt.*;
import javax.swing.*; 

/** Extension of AbstractTaskMonitorDialog containing a button enabled task panel
  * component for controlling the task starting, stopping, and dialog disposal.
  * By default, this dialog does not automatically dispose of dialog if task stops.
  * Use setDisposeOnStop(true) to change default behavior.
 */
public class TaskMonitorButtonBoxDialog extends AbstractTaskMonitorDialog {

    public TaskMonitorButtonBoxDialog() {
        super();
        progressMeterVisible  = true;
        disposeOnStop         = false;
    }

/**
  * Creates a TaskMonitorButtonBoxPanel for this Dialog component type.
*/
    protected AbstractTaskMonitorPanel createTaskMonitorPanel(AbstractMonitorableTask task) {
        return new TaskMonitorButtonBoxPanel(task);
    }

/**
  * Defaults always true, since the dialog's task is supposedly under button control.
*/ 
    public void setProgressMeterVisible(boolean value) {
         progressMeterVisible = true;   // always visible
    }

}

