package org.trinet.util;
/**
 * General purpose range (pair) of integer values
 *@deprecated Replaced by org.trinet.util.IntegerRange.
 */
public class RangeInt
{
    public int min;
    public int max;

    public RangeInt (int mn, int mx)
    {
	set (mn, mx);
    }

/**
 * Set/reset the max/min values in the range
 */
    public void set (int mn, int mx)
    {
	min = mn;
	max = mx;

	// auto swap incase caller blew it

	if (min > max)
	{
	    int tmp = min;
	    min = max;	    //swap
	    max = tmp;
	}
    }

    public void include ( int val )
    {
	if (val < min) min = val;
	if (val > max) max = val;
    }

/**
 * Adjust current range to include range in argument
 */
    public void include (RangeInt range)
    {
	if (range.min < min) min = range.min;
	if (range.max > max) max = range.max;
    }

    public boolean isIn (int val)
    {
	if (val >= min && val <= max) return true;
	return false;
    }

    public boolean isIn (RangeInt range)
    {
	if (range.min >= min && range.max <= max) return true;
	return false;
    }

    public int size()
    {
      return max - min;
    }

   public String toString() {
       return min + ", " + max;
    }

} // end of class
