package org.trinet.util.graphics;
/*
 * This class is based on /opt/jdk1.2beta4/demo/jfc/Metalworks/src/MetalworksHelp.java
 * @version 1.4 04/24/98
 * @author Steve Wilson
 * Copyright 1998 by Sun Microsystems, Inc.,
 *
 * Modified by DDG Jan. 12, 1999. Allowed caller to define help file, changed to JFrame
 * from JInternalFrame
 */

import javax.swing.*;
import java.awt.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.*;
import javax.swing.text.*;
import javax.swing.event.*;

/**
 * Generic help window that displays HTML documents. Only works with LOCAL files.
 */
//public class HTMLHelp extends JInternalFrame { 
public class HTMLHelp extends JFrame { 

    public HTMLHelp(String helpFile, String title) 
    {
	super("Help");

	if (title != null)
	{
	  setTitle(title);	// set title to caller's
	}

//    	setFrameIcon( (Icon)UIManager.get("Tree.openIcon")); // PENDING(steve) need more general palce to get this icon
	setBounds( 200, 25, 400, 400);
	HtmlPane html = new HtmlPane(helpFile);

	getContentPane().add(html);

	setVisible(true);
    }

} // end of class


class HtmlPane extends JScrollPane implements HyperlinkListener {
    JEditorPane html;

    public HtmlPane(String helpFile) {
	try {
//	    File f = new File ("HelpFiles/toc.html");
	    File f = new File (helpFile);
	    String s = f.getAbsolutePath();

	    s = "file:"+s;
	    URL url = new URL(s);
	    html = new JEditorPane(s);
	    html.setEditable(false);
	    html.addHyperlinkListener(this);

	    JViewport vp = getViewport();
	    vp.add(html);
	} catch (MalformedURLException e) {
	    System.out.println("Malformed URL: " + e);
	} catch (IOException e) {
	    System.out.println("IOException: " + e);
	}	
    }

    /**
     * Notification of a change relative to a 
     * hyperlink.
     */
    public void hyperlinkUpdate(HyperlinkEvent e) {
	if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
	    linkActivated(e.getURL());
	}
    }

    /**
     * Follows the reference in an
     * link.  The given url is the requested reference.
     * By default this calls <a href="#setPage">setPage</a>,
     * and if an exception is thrown the original previous
     * document is restored and a beep sounded.  If an 
     * attempt was made to follow a link, but it represented
     * a malformed url, this method will be called with a
     * null argument.
     *
     * @param u the URL to follow
     */
    protected void linkActivated(URL u) {
	Cursor c = html.getCursor();
	Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
	html.setCursor(waitCursor);
	SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    /**
     * temporary class that loads synchronously (although
     * later than the request so that a cursor change
     * can be done).
     */
    class PageLoader implements Runnable {
	
	PageLoader(URL u, Cursor c) {
	    url = u;
	    cursor = c;
	}

        public void run() {
	    if (url == null) {
		// restore the original cursor
		html.setCursor(cursor);

		// PENDING(prinz) remove this hack when 
		// automatic validation is activated.
		Container parent = html.getParent();
		parent.repaint();
	    } else {
		Document doc = html.getDocument();
		try {
		    html.setPage(url);
		} catch (IOException ioe) {
		    html.setDocument(doc);
		    getToolkit().beep();
		} finally {
		    // schedule the cursor to revert after
		    // the paint has happended.
		    url = null;
		    SwingUtilities.invokeLater(this);
		}
	    }
	}

	URL url;
	Cursor cursor;
    }

}
