package org.trinet.util.graphics;

import java.awt.*;

/**
 * Extends class Color to add new colors and the concept of an ordered color list. Also,
 * controls the definition of certain general use colors, e.g. the color of an unassociated
 * pick.
 */
public class ColorList
{

// The following public static Colors were created using a Java tool at:
//  http://www.cadvision.com/ewertb/Java_public static ColorPicker.html

//			color                            R    G    B
    public static Color tan	  = new Color (225, 190, 145);
    public static Color brown	  = new Color (160, 125,  80);
    public static Color medBrown  = new Color (190, 155, 100);
    public static Color navyBlue  = new Color ( 30,  20, 100);
    public static Color skyBlue   = new Color (165, 220, 255);
    public static Color aliceBlue = new Color (240, 248, 255);
    public static Color medBlue   = new Color (125, 170, 255);
    public static Color slateBlue = new Color (160, 180, 200);
    public static Color brickRed  = new Color (170,  30,  70);
    public static Color peaGreen  = new Color (160, 175,  60);
    public static Color kellyGreen= new Color ( 20, 160,  20);
    public static Color olive     = new Color (105, 135,  20);
    public static Color purple    = new Color (165, 115, 200);
    public static Color plumb     = new Color (175,   0, 255);
    public static Color lavender  = new Color (225, 170, 220);
    public static Color buff      = new Color (220, 220, 175);
    public static Color gold      = new Color (255, 225,   0);
    public static Color mint      = new Color (175, 255, 175);
    public static Color violet    = new Color (105,  45, 165);
    public static Color indigo    = new Color ( 70,  65, 175);
    public static Color burntOrange=new Color (255, 150,   0);

// Defining special colors here insures that all components act uniformly and color will not
// conflict.

/** Special color to be used for unassociated PickMarkers, etc. */
    public static Color UNASSOC = Color.gray;

/** Special color to be used for active (changing) PickMarkers, etc. */
    public static Color ACTIVE = gold;

// This is the ordered color list used for multiple events in the same view
// Colors were choosen for visibility and distinctness
    public static Color intColor[] = {

	Color.red,	    // spectrum starts here
	Color.orange,
	Color.green,
	Color.pink,
	tan,
	skyBlue,
	brickRed,
     peaGreen,
	purple,
     lavender,
	buff,
	mint
    };


public ColorList() {}

public static int getColorCount() {
    return intColor.length;
}

/**
 * Return a color that corrisponds to this int in the color list.
 * Uses modulus operator to "wrap" and repeat color order if value exceeds list size.
 */
public static Color getColor(int i) {
    return  intColor[i%intColor.length] ;
}

}
