package org.trinet.pcs;

  /**
   * Structure of the Process Table 'PCS_State'
   */

import java.sql.*;
import java.util.*;

public class StateRow
{
  public long   id;			// NOT NULL
  public String controlGroup;		// NOT NULL
  public String sourceTable;		// NOT NULL
  public String state;			// NOT NULL
  public int    rank;			// NOT NULL
  public int	result;
  public long   secondaryId;
  public String secondarySourceTable;
  public String auth;
  public String subsource;
  public java.sql.Date lddate;

  public StateRow() {}	// null constructor

  /**
   * Copy a State Row
   */
  public StateRow(StateRow pr)
    {
      id =		pr.id;				// NOT NULL
      controlGroup =	pr.controlGroup;		// NOT NULL
      sourceTable =	pr.sourceTable;			// NOT NULL
      state =		pr.state;			// NOT NULL
      rank =		pr.rank;			// NOT NULL
      result =		pr.result;
      secondaryId =	pr.secondaryId;
      secondarySourceTable = pr.secondarySourceTable;
      auth =		pr.auth;
      subsource =	pr.subsource;
      lddate =		pr.lddate;

    }

  /**
   * Insert ONE process row into the dbase
   */
  public int insert ()
    {
      // check NOT NULL fields
      // transitions to no new state will result in StateRow objects with
      // null values for state and rank
      if (!meetsConstraints()) return 0;

      String sql = "INSERT into "+ProcessControl.StateTable+" ("+
	fieldString() +
	" , lddate) values (" +
	toValueString() +
	", SYSDATE)" ;

      // debug
      //      System.out.println ("from insert: "+sql);

      return doUpdate (sql);

    }
    /** Return true if this StateRow meets the NOT NULL constraints. This is a
     *  bit risky because the constraints in the dbase could be changed.*/
     /* This was added 1/14/2002 to stop insert() from causing constraint errors
     * when Transition processed events that were "terminal". That is, were not
     * posted to a new state.
     */
    boolean meetsConstraints () {
      return (!znull(id).equals("NULL") &&
	      controlGroup != null &&
	      sourceTable != null &&
	      state != null &&
	      !znull(rank).equals("NULL") );
    }
  /**
   * Insert all these process rows into the dbase
   */
  public static int insertArray (StateRow pr[])
    {
      int nrows=0;
      for (int i = 0; i < pr.length; i++)
	{
	 nrows += pr[i].insert();
	}
      return nrows;
    }

  /**
   * Delete this process row
   */
  public int delete ()
    {
      String sql = "Delete from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+controlGroup+"'"+
	" and sourceTable = '"+sourceTable+"'"+
	" and id = "+id+
	" and state = '"+state+"'"+
	" and rank = "+ rank;

      return doUpdate (sql);

    }

  /**
   * Delete this process row
   */
  public static int delete (String cGroup, String sTable, long id)
    {
      String sql = "Delete from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+sTable+"'"+
	" and id = "+id;

      return doUpdate (sql);

    }

  /**
   * Delete this process row
   */
  public static int delete (String cGroup, String sTable)
    {
      String sql = "Delete from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+sTable+"'";

      return doUpdate (sql);

    }

  /**
   * Delete this process row
   */
  public static int delete (String cGroup)
    {
      String sql = "Delete from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'";

      return doUpdate (sql);

    }

  public static int doUpdate(String sql)
    {
      ProcessControl.makeConnection();

      int nrows = 0;
      try {
	Statement stmt = ProcessControl.conn.createStatement();
	nrows = stmt.executeUpdate(sql);
	ProcessControl.conn.commit();
	stmt.close();
      }
      catch (SQLException ex) {
	ex.printStackTrace(System.err);
	System.err.println("SQL: " + sql);
      }

      return nrows;
    }

 /** ******************************************************************
   * Return all State Table rows for this group/table/ID sorted by
   * rank in descending order
   */
  public static
    StateRow[] get(String cGroup, String cTable, long id)

    {
      String sql =
	"SELECT * from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" and id = "+id +" order by rank DESC";
      return doQuery(sql);
    }

  /**
   * Return all State table rows for this group/table/state.
   */
  public static StateRow[] get(String cGroup, String cTable, String state)

    {
      String sql =
	"SELECT * from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" and state = '"+state+"'"+
	" order by result DESC";

      return doQuery(sql);
    }

  /**
   * Return all State table rows for this group/table
   */
  public static StateRow[] get(String cGroup, String cTable)

    {
      String sql =
	"SELECT * from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" order by result DESC";

      return doQuery(sql);
    }
  /**
   * Return all State table rows for this group
   */
  public static StateRow[] get(String cGroup)

    {
      String sql =
	"SELECT * from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" order by result DESC";

      return doQuery(sql);
    }
  /**
   * Return all State table rows
   */
  public static StateRow[] get()

    {
      String sql =
	"SELECT * from "+ProcessControl.StateTable+" order by id, state, rank, result DESC";

      return doQuery(sql);
    }

  /**
   * Return array of StateRow's containing IDs for the given group/table/state.
   * Rows are sorted by 'lddate' so that the oldest entries come first.
   * Thus this acts as a FIFO. Returns null if none found.
   */

  public static
    StateRow[] getNextArray (String group, String sourceTable, String state)
     {
       // Now here's some fancy SQL
       String sql = "select * from pcs_state ST "+
	 " where controlGroup = '"+group+"' and "+
	 " sourceTable = '"+sourceTable+"' and "+
	 " state = '"+state+"' and "+
	 " (result = 0 or result is null) and"+
	 " rank = (select max(rank) from pcs_state where id = ST.id)"+
	 " order by lddate ";

          return doQuery(sql);

     }

  /**
   * Return one StateRow containing an ID for the given group/table/state.
   * The lowest ID is returned.
   */

  public static
    StateRow getNext (String group, String sourceTable, String state)
     {
       StateRow[] sr = getNextArray(group, sourceTable, state);

       if (sr == null) return null;

       return sr[0];	// only return 1st in the list

     }
  /**
   * Return next ID for the given group/table/state.
   * If no id's returns -1.
   */

  public static long getNextId (String group, String sourceTable, String state)
     {
       StateRow[] sr = getNextArray(group, sourceTable, state);

       if (sr == null) return -1;

       return sr[0].id;	// only return 1st in the list

     }

  /**
   * Return all State table rows with non-zero result codes. These are
   * likely to require transitions
   */
  public static StateRow[] getNonNullResults()
    {
      String sql =
	"SELECT * from "+ProcessControl.StateTable+" where "+
	"(result <> 0 or result is not null) order by result DESC";

      return doQuery(sql);
    }

  /**
   * Return all State table rows with non-zero result codes. These are
   * likely to require transitions
   */
  public static StateRow[] getNonNullResults(String cGroup, String cTable)
    {
      String sql =
	"SELECT * from "+ProcessControl.StateTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" and (result <> 0 or result is not null) order by result DESC";

      return doQuery(sql);
    }

  /**
   * Return all State Table rows that satisfy this 'sql' query
   */
  public static StateRow[] doQuery (String sql)
    {
      //System.out.println(sql);
      ResultSet rs;
      int nrows = 0;
      StateRow prRow;
      Vector v = new Vector() ;

      ProcessControl.makeConnection(); // use existing or make new connection

      try {

	Statement stmt = ProcessControl.conn.createStatement();

	rs = stmt.executeQuery(sql);

	while ( rs.next() ) {
	  prRow = StateRow.parse(rs);
	  if (prRow == null) break;
	  v.addElement((Object) prRow);
	  nrows++;
	}

	stmt.close();		//closes statement & resultset

      } catch (SQLException ex) {
	ex.printStackTrace(System.err);
	return null;
      }

      // Copy resulting vector into array for return
      if ( v.size() > 0) {
	StateRow pr[] = new StateRow [nrows];
	v.copyInto(pr);
	return pr;
      }
      else {
	return null;
      }

    }

/**
 * Convert data members to a comma delimited list for use with INSERT and UPDATE.
 * Note that 'lddate' is not included
 */
  public String toValueString()
    {
	return
	  znull(id) + ", " +
	  "'"+ controlGroup + "', " +
	  "'"+ sourceTable + "', " +
	  "'"+ state + "', " +
	  znull(rank) + ", " +
	  znull(result) + ", " +
	  znull(secondaryId) + ", " +
	  "'"+ secondarySourceTable + "', " +
	  "'"+ auth + "', " +
	  "'"+ subsource+"'" ;
    }
  /** String for output of status */
  public static final int MAX_FIELD_WIDTH = 16;
  public static final char [] BLANKS = new char [MAX_FIELD_WIDTH];
  static {
     Arrays.fill(BLANKS, 0, MAX_FIELD_WIDTH, ' ');
  }
  private int getFillCount(String value) {
      int fillCount = (value == null) ? MAX_FIELD_WIDTH :  MAX_FIELD_WIDTH - value.length();
      return (fillCount > 0) ? fillCount : 0;
  }
  private StringBuffer appendPaddedField(StringBuffer sb, String value) {
      sb.append(BLANKS, 0, getFillCount(value));
      sb.append(value).append(" ");
      return sb;
  }
  public String toOutputString()
    {
      StringBuffer sb = new StringBuffer(132);
      String idStr = String.valueOf(id);
      String rankStr = String.valueOf(rank);
      String resultStr = String.valueOf(result);
      appendPaddedField(sb, idStr);
      appendPaddedField(sb, controlGroup);
      appendPaddedField(sb, sourceTable);
      appendPaddedField(sb, state);
      appendPaddedField(sb, rankStr);
      appendPaddedField(sb, resultStr);
      return sb.toString();
      //return id +" : "+ controlGroup +" "+ sourceTable +" " + state +"    "+ rank + "  "+result;
    }

  public static String fieldString()
    {
	return 	" id, controlGroup, sourceTable, state, rank, result," +
	" secondaryId, secondarySourceTable, " +
	" auth, subsource";
    }

  public static void dump (StateRow sr[])
    {
      if (sr == null)
	{
	  System.out.println (" * No entries *");
	  return;
	}
      for (int i=0; i < sr.length; i++)
	{
	  System.out.println (sr[i].toOutputString());
	}
    }

  public static void dump (StateRow sr)
    {
      if (sr == null)
	{
	    //	  System.out.println (" * No entries *");
	  return;
	}

      System.out.println (sr.toOutputString());

    }

  /** Parse resultset into this StateRow */
  public static StateRow parse (ResultSet rs)
    {
      StateRow pr = new StateRow();
        try {

	  pr.id			= rs.getLong("id");
	  pr.controlGroup	= getStringSafe(rs, "controlGroup");
	  pr.sourceTable	= getStringSafe(rs, "sourceTable");
	  pr.state		= getStringSafe(rs, "state");
	  pr.rank		= rs.getInt("rank");
	  pr.result		= rs.getInt("result");
	  pr.secondaryId  	= rs.getLong("secondaryId");

	  pr.secondarySourceTable = getStringSafe(rs, "secondarySourceTable");
	  pr.auth		= getStringSafe(rs, "auth");
	  pr.subsource		= getStringSafe(rs, "subsource");
	  pr.lddate      	= rs.getDate("lddate");

	} catch ( NullPointerException ex) {
            System.err.println("NullPointerException in parseResults");
            ex.printStackTrace(System.err);
	    return null;
        } catch ( SQLException ex) {
            System.err.println("SQLException");
            ex.printStackTrace(System.err);;
	    return null;
        }

	return pr;
    }
/**
 * Allow safe building of INSERT and UPDATE commands when some fields can be null
 */
    public static String znull(float val)
    {
        if (val == 0.0) return "NULL";
        return String.valueOf(val);
    }

    public static String znull(int ival)
    {
        if (ival == 0) return "NULL";
        return String.valueOf(ival);
    }
    public static String znull(long ival)
    {
        if (ival == 0l) return "NULL";
        return String.valueOf(ival);
    }
    static String getStringSafe(ResultSet rs, String column)
    {
        try{
            String str = rs.getString(column);
            if (str == null) return "";
            return str;
        } catch ( NullPointerException ex) {
            System.err.println("NullPointerException");
            ex.printStackTrace(System.err);
            return "";
        } catch ( SQLException ex) {
            System.err.println("SQLException");
            ex.printStackTrace(System.err);
            return "";
        }
    }



}
