package org.trinet.jiggle;

import java.text.*;
import java.util.*;
import java.io.*;

import java.awt.*;
import javax.swing.*;
import org.trinet.util.graphics.ColorList;
import org.trinet.util.*;

/*
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Can't get this to work worth a shit! Doesn't always repaint. Seems to contain
random scratch graphics.
 */

/**
 * Create a panel with a time scale for use in the ColumnHeader of the
 * ZoomePanel scrollpane.
 */
// TODO: add modes for tick levels, change color, etc.

public class TimeColumnHeader extends JLabel {

	//TODO: look this up from scrollPane or pass as arg.

    // Set default colors
    Color foregroundColor = Color.black;
    Color backgroundColor = ColorList.buff;

    //    Dimension panelSize;
    WFPanel wfp;

    TimeSpan timeSpan;
    double pixelsPerSec;
    double startTime;
    double duration;
    int headerHeight = 18;		// default height

    int tick;
    int x;
    double sec;

    String str;
//    SimpleDateFormat timeFmt = new SimpleDateFormat ("mm:ss");

    // default font
    int fontSize = 12;
    //    Font font = new Font("Serif",Font.ITALIC | Font.BOLD, fontSize);
    Font font = new Font("Serif", Font.BOLD, fontSize);

    /**
     * Create the time TimeColumnHeader for this WFPanel.
     */
public TimeColumnHeader (WFPanel wfp) {

    this.wfp = wfp;

    setBackground(backgroundColor);

    // neither solves problem that this is sometimes not repainted
//    setOpaque(false);
    setOpaque(true);

}

    /** used by super.paint() to set size of lable = panel */
public Dimension getPreferredSize()
{
    return new Dimension(wfp.getWidth(), headerHeight);

}

/**
 * Paint the scale
 */
public void paintComponent (Graphics g) {

    super.paintComponent(g);	// give super and delegate chance to paint

    setSize(getPreferredSize());

    // fill background with proper color
    // without this the painting is irratic
    g.setColor(backgroundColor);
    Rectangle r = g.getClipBounds();          // get damaged region
    g.fillRect(r.x, r.y, r.width, r.height);

    g.setColor (foregroundColor);
    g.setFont(font);

    duration  = wfp.panelBox.getTimeSpan().size();
    startTime = wfp.panelBox.getTimeSpan().getStart();
    pixelsPerSec = (double) wfp.getWidth() / duration;
    double frac	= startTime - (double) ((long) startTime);
    double wholeSec = startTime - frac;
    int height = getHeight();

    // TODO: optimize by only plotting scale within getClipBounds()
     //TODO: make ticks at 0.1 or 0.01 secs if scale is small?
     for (int tsec=1; tsec < duration; tsec++) {

	    sec = wholeSec + (double) tsec;
	    x = ((int) ((sec - startTime) * pixelsPerSec));  //pixel of time

	    tick = height / 8;			// 1 sec ticks
	    if (sec% 5 == 0) tick = height/4;	// 5 sec
	    if (sec%10 == 0) tick = height/2;	// 10 sec
	    if (sec%60 == 0) {
	        tick = height;			// 60 sec, write time
                String label = EpochTime.epochToString (sec, "HH:mm");
	        g.drawString(label, x+2, tick-4);	// bad magic numbers
	    }

	    // label minute tick here
	    g.drawLine (x, 0, x, tick);
     }

     // if scale is really big make 0.1 sec ticks
     if (pixelsPerSec > 40) {
       tick = height/12;
       for (float fsec=1; fsec < duration; fsec += 0.1) {
	    sec = wholeSec + fsec;
	    x = ((int) ((sec - startTime) * pixelsPerSec));  //pixel of time
	    g.drawLine (x, 0, x, tick);
       }
     }

}

}

