
/**
Panel with components for input of magnitude information.
Allows changing: value, mag type, authority, source and method. The resulting mag
will NOT carry along any other info from the original mag, like nsta, because it would
no longer be valid. It also does not inherit the amplitude list. Thus, a hand entered mag will have no amps.
*/

package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;
import org.trinet.jasi.Magnitude;
import java.awt.event.*;
import java.text.*;
import org.trinet.jdbc.datatypes.DataString;
import org.trinet.jdbc.datatypes.DataObject;
import org.trinet.jasi.*;

public class DPmagnitude extends JPanel {

       /** the magnitude */
       Magnitude mag = Magnitude.create();

     JPanel inputPanel = new JPanel();
     GridLayout gridLayout2 = new GridLayout(0, 1);
     JComboBox valCombo = new JComboBox();
     JComboBox typeCombo = new JComboBox();

     BorderLayout borderLayout1 = new BorderLayout();
     Box horizBox;

     JTextField sourceText = new JTextField();
     JTextField authText = new JTextField();
     JTextField methodText = new JTextField();
     JTextField nreadingsText = new JTextField();
     JTextField errorText = new JTextField();

     JLabel valueLabel = new JLabel();
     JLabel authLabel = new JLabel();
     JLabel typeLabel = new JLabel();
     JLabel sourceLabel = new JLabel();
     JLabel nreadingsLabel = new JLabel();
     JLabel errorLabel = new JLabel();          //standard deviation of the magnitude

     JPanel lablePanel = new JPanel();

     GridLayout gridLayout1 = new GridLayout(0, 1);
     JLabel methodLabel = new JLabel();

     // format for mag values
	DecimalFormat df = new DecimalFormat ( "0.00" );
// distance format

     public DPmagnitude() {

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
     }

     /** Create a Magnitude dialog panel with default values set to the values
     of the given Magnitude object. */
     public DPmagnitude(Magnitude magnitude) {

          this.mag = magnitude;

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }

          // set default values
          if (mag == null) mag = Magnitude.create();

          // these are set in Magnitude.create so they're always safe
          sourceText.setText(mag.source.toString());
          authText.setText(mag.authority.toString());

          // new mag, use defaults
          if (mag.value.isNull()) {
            valCombo.setSelectedItem(df.format(1.50));
            typeCombo.setSelectedItem("Mh");
            methodText.setText("HAND");
            nreadingsText.setText("0");
            errorText.setText(df.format(0.0));
          } else {
            valCombo.setSelectedItem(df.format(mag.value.doubleValue()));
            typeCombo.setSelectedItem(mag.getTypeString());
            methodText.setText(mag.method.toString());
            nreadingsText.setText(""+mag.getReadingsUsed());
	    // null value results in "NaN" which screws up parse later
	    if (mag.error.isNull()) {
	      errorText.setText(df.format(0.0));
	    } else {
              errorText.setText(mag.error.toString());
	    }
          }
     }

     private void jbInit() throws Exception {
          horizBox = Box.createHorizontalBox();
          this.setLayout(borderLayout1);
          inputPanel.setLayout(gridLayout2);
          gridLayout2.setColumns(1);
          gridLayout2.setRows(0);

          valueLabel.setHorizontalAlignment(SwingConstants.RIGHT);
          valueLabel.setText("Value");
          authLabel.setHorizontalAlignment(SwingConstants.RIGHT);
          authLabel.setText("Authority");
          typeLabel.setHorizontalAlignment(SwingConstants.RIGHT);
          typeLabel.setText("Type");
          sourceLabel.setHorizontalAlignment(SwingConstants.RIGHT);
          sourceLabel.setText("Source");
          nreadingsLabel.setText("# Readings");
          nreadingsLabel.setHorizontalAlignment(SwingConstants.RIGHT);
          errorLabel.setText("Error");
          errorLabel.setHorizontalAlignment(SwingConstants.RIGHT);

          lablePanel.setLayout(gridLayout1);
          gridLayout1.setColumns(1);
          gridLayout1.setRows(0);
          methodLabel.setHorizontalAlignment(SwingConstants.RIGHT);
          methodLabel.setText("Method");
          this.add(horizBox, BorderLayout.CENTER);
          horizBox.add(lablePanel, null);
          horizBox.add(Box.createHorizontalStrut(5));

          lablePanel.add(valueLabel, null);
          lablePanel.add(typeLabel, null);
          lablePanel.add(authLabel, null);
          lablePanel.add(sourceLabel, null);
          lablePanel.add(methodLabel, null);
          lablePanel.add(nreadingsLabel, null);
          lablePanel.add(errorLabel, null);

          horizBox.add(inputPanel, null);
          inputPanel.add(valCombo, null);
          inputPanel.add(typeCombo, null);
          inputPanel.add(authText, null);
          inputPanel.add(sourceText, null);
          inputPanel.add(methodText, null);
          inputPanel.add(nreadingsText, null);
          inputPanel.add(errorText, null);
          errorText.setToolTipText("Standard deviation of the magnitude");

          // populate the combos
          valCombo.setEditable(true);		    // allow freeform user input
          for (double m = 0.0; m <= 8.0; m += 0.1) {
            valCombo.addItem(df.format(m));
          }

          // this is the order of precidence for So Cal.
          typeCombo.addItem("Mw");
          typeCombo.addItem("Ms");
          typeCombo.addItem("Me");
          typeCombo.addItem("Ml");
          typeCombo.addItem("Mc");
          typeCombo.addItem("Mh");
          typeCombo.addItem("Md");
          typeCombo.addItem("Mb");

     }

     /** Reads the dialog components and returns a magnitude resulting from
     the the values in them. */
     public Magnitude getMag() {

     // make a virgin magnitude, don't keep field from old you can't support
       Magnitude newMag = Magnitude.create();

       // keep solution association
       if (mag.sol != null) newMag.associate(mag.sol);

       String str = (String) valCombo.getSelectedItem();

       Double dval = Double.valueOf(str.trim());
       double val = dval.doubleValue();
       newMag.value.setValue(val);

       String subscript = (String) typeCombo.getSelectedItem();
       subscript = subscript.substring(1); // remove "M" on front
       newMag.subScript.setValue(subscript);

       // treat word "null" or a blank as a real null
       parseText (newMag.authority, authText);
       parseText (newMag.source,    sourceText);
       parseText (newMag.method,    methodText);

//       parseValue (newMag.usedReadings, nreadingsText);
       parseValue (newMag.error, errorText);

       // manually entered mag has not values for these

       newMag.processingState.setValue("H");

       // set other fields null or zero here?

       return newMag;
     }

     /** Treat word "null" or a blank as a real null */
     protected void parseText (DataString dataString, JTextField field) {

       String str = field.getText().trim();    // the field text

       if (str.equalsIgnoreCase("NULL") ||
           str.length() == 0) {
           dataString.setNull(true);
       } else {
         dataString.setValue(str);
       }
     }
     /** Treat word "null", "NaN" or a blank as a real null */
     protected void parseValue (DataObject dataObj, JTextField field) {

       String str = field.getText().trim();    // the field text
       if (str.equalsIgnoreCase("NULL") ||
	   str.equalsIgnoreCase("NaN") ||
           str.length() == 0) {
           dataObj.setNull(true);
       } else {

         Double dval = Double.valueOf( str );     // convert to double
         double val = dval.doubleValue();

         dataObj.setValue(val);
       }
     }

     // ///////////////////////////////////////////////////
         public static void main(String s[])
    {

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
      	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
          });

        Magnitude mag = Magnitude.create();

        DPmagnitude dia = new DPmagnitude(mag);

        frame.getContentPane().add(dia);


        frame.pack();
        frame.setVisible(true);

    }

}
