package org.trinet.jiggle;

import org.trinet.util.graphics.ColorList;
import java.awt.Color;
import org.trinet.jasi.Channel;

/**
 * ComponentColor.java
 *
 *
 * Created: Thu Nov  4 13:38:07 1999
 *
 * @author Doug Given
 * @version
 */

public class ComponentColor {

      static Color colorBHZ = ColorList.medBrown;	    // broadband
      static Color colorBHN = ColorList.medBrown;
      static Color colorBHE = ColorList.medBrown;

      static Color colorHHZ = Color.black;	    // broadband highgain
      static Color colorHHN = Color.black;
      static Color colorHHE = Color.black;

      static Color colorHLZ = ColorList.medBrown;	    // broadband lowgain (FBA)
      static Color colorHLN = ColorList.medBrown;
      static Color colorHLE = ColorList.medBrown;

      static Color colorVHZ = Color.blue;	    // shortperiod(analog) lowgain
      static Color colorVHN = Color.blue;
      static Color colorVHE = Color.blue;

      static Color colorVLZ = ColorList.medBrown;   // OLD STYLE shortperiod (analog) highgain
      static Color colorVLN = ColorList.medBrown;
      static Color colorVLE = ColorList.medBrown;

      static Color colorEHZ = Color.blue;    // shortperiod (analog) highgain
      static Color colorEHN = Color.blue;
      static Color colorEHE = Color.blue;

      static Color colorELZ = ColorList.medBrown;	    // shortperiod (analog) lowgain
      static Color colorELN = ColorList.medBrown;
      static Color colorELE = ColorList.medBrown;

      static Color colorSHT = Color.gray;
      static Color colorT   = ColorList.brickRed;

    /** No public Constructor: this is a purely static class */
    ComponentColor() {

    }
    /**-------------------------------------------------------------------
     * Return the drawing color for each component.
     */
  public static Color get (Channel chan)
    {
	if (chan == null) return get("SHT");
	return get(chan.getSeedchan());
//	return get(chan.getChannel());
    }

    /**-------------------------------------------------------------------
     * Return the drawing color for each component.
     */
  public static Color get (String str)
    {

      if (str.equalsIgnoreCase("SHT")) return (colorSHT);
      if (str.equalsIgnoreCase("T"))   return (colorT);

      if (str.equalsIgnoreCase("BHZ")) return (colorBHZ);
      if (str.equalsIgnoreCase("BHN")) return (colorBHN);
      if (str.equalsIgnoreCase("BHE")) return (colorBHE);

      if (str.equalsIgnoreCase("HHZ")) return (colorHHZ);
      if (str.equalsIgnoreCase("HHN")) return (colorHHN);
      if (str.equalsIgnoreCase("HHE")) return (colorHHE);

      if (str.equalsIgnoreCase("HLZ")) return (colorHLZ);
      if (str.equalsIgnoreCase("HLN")) return (colorHLN);
      if (str.equalsIgnoreCase("HLE")) return (colorHLE);

      if (str.equalsIgnoreCase("VHZ")) return (colorVHZ);
      if (str.equalsIgnoreCase("VHN")) return (colorVHN);
      if (str.equalsIgnoreCase("VHE")) return (colorVHE);

      if (str.equalsIgnoreCase("VLZ")) return (colorVLZ);
      if (str.equalsIgnoreCase("VLN")) return (colorVLN);
      if (str.equalsIgnoreCase("VLE")) return (colorVLE);

      if (str.equalsIgnoreCase("EHZ")) return (colorEHZ);
      if (str.equalsIgnoreCase("EHN")) return (colorEHN);
      if (str.equalsIgnoreCase("EHE")) return (colorEHE);

      if (str.equalsIgnoreCase("ELZ")) return (colorELZ);
      if (str.equalsIgnoreCase("ELN")) return (colorELN);
      if (str.equalsIgnoreCase("ELE")) return (colorELE);

      return (Color.black);		// default
    }

} // ComponentColor
