package org.trinet.jdbc.table;
import org.trinet.jdbc.datatypes.DataClassIds;
/** Interface of static data constants defining the named table.
* @see Amp
*/
public interface TableRowAmp extends DataClassIds {

/** Name of schema database table represented by this class.
*/
    public static final String DB_TABLE_NAME =  "AMP";

/** Number of column data fields in a table row.
*/
    public static final int MAX_FIELDS =  27;

/** Id sequence name for primary key column
*/
    public static String SEQUENCE_NAME = "AMPSEQ";


/**  AMP table "ampid" column data object offset in collection stored by implementing class.
*/
    public static final int AMPID = 0;

/**  AMP table "commid" column data object offset in collection stored by implementing class.
*/
    public static final int COMMID = 1;

/**  AMP table "datetime" column data object offset in collection stored by implementing class.
*/
    public static final int DATETIME = 2;

/**  AMP table "sta" column data object offset in collection stored by implementing class.
*/
    public static final int STA = 3;

/**  AMP table "net" column data object offset in collection stored by implementing class.
*/
    public static final int NET = 4;

/**  AMP table "auth" column data object offset in collection stored by implementing class.
*/
    public static final int AUTH = 5;

/**  AMP table "subsource" column data object offset in collection stored by implementing class.
*/
    public static final int SUBSOURCE = 6;

/**  AMP table "channel" column data object offset in collection stored by implementing class.
*/
    public static final int CHANNEL = 7;

/**  AMP table "channelsrc" column data object offset in collection stored by implementing class.
*/
    public static final int CHANNELSRC = 8;

/**  AMP table "seedchan" column data object offset in collection stored by implementing class.
*/
    public static final int SEEDCHAN = 9;

/**  AMP table "location" column data object offset in collection stored by implementing class.
*/
    public static final int LOCATION = 10;

/**  AMP table "iphase" column data object offset in collection stored by implementing class.
*/
    public static final int IPHASE = 11;

/**  AMP table "amplitude" column data object offset in collection stored by implementing class.
*/
    public static final int AMPLITUDE = 12;

/**  AMP table "amptype" column data object offset in collection stored by implementing class.
*/
    public static final int AMPTYPE = 13;

/**  AMP table "units" column data object offset in collection stored by implementing class.
*/
    public static final int UNITS = 14;

/**  AMP table "ampmeas" column data object offset in collection stored by implementing class.
*/
    public static final int AMPMEAS = 15;

/**  AMP table "eramp" column data object offset in collection stored by implementing class.
*/
    public static final int ERAMP = 16;

/**  AMP table "flagamp" column data object offset in collection stored by implementing class.
*/
    public static final int FLAGAMP = 17;

/**  AMP table "per" column data object offset in collection stored by implementing class.
*/
    public static final int PER = 18;

/**  AMP table "snr" column data object offset in collection stored by implementing class.
*/
    public static final int SNR = 19;

/**  AMP table "tau" column data object offset in collection stored by implementing class.
*/
    public static final int TAU = 20;

/**  AMP table "quality" column data object offset in collection stored by implementing class.
*/
    public static final int QUALITY = 21;

/**  AMP table "rflag" column data object offset in collection stored by implementing class.
*/
    public static final int RFLAG = 22;

/**  AMP table "cflag" column data object offset in collection stored by implementing class.
*/
    public static final int CFLAG = 23;

/**  AMP table "wstart" column data object offset in collection stored by implementing class.
*/
    public static final int WSTART = 24;

/**  AMP table "duration" column data object offset in collection stored by implementing class.
*/
    public static final int DURATION = 25;

/**  AMP table "lddate" column data object offset in collection stored by implementing class.
*/
    public static final int LDDATE = 26;
/** String of know column names delimited by ",".
*/
    public static final String COLUMN_NAMES =
   "AMPID,COMMID,DATETIME,STA,NET,AUTH,SUBSOURCE,CHANNEL,CHANNELSRC,SEEDCHAN,LOCATION,IPHASE,AMPLITUDE,AMPTYPE,UNITS,AMPMEAS,ERAMP,FLAGAMP,PER,SNR,TAU,QUALITY,RFLAG,CFLAG,WSTART,DURATION,LDDATE";

/** String of table qualified column names delimited by ",".
*/
    public static final String QUALIFIED_COLUMN_NAMES = 
    "AMP.AMPID,AMP.COMMID,AMP.DATETIME,AMP.STA,AMP.NET,AMP.AUTH,AMP.SUBSOURCE,AMP.CHANNEL,AMP.CHANNELSRC,AMP.SEEDCHAN,AMP.LOCATION,AMP.IPHASE,AMP.AMPLITUDE,AMP.AMPTYPE,AMP.UNITS,AMP.AMPMEAS,AMP.ERAMP,AMP.FLAGAMP,AMP.PER,AMP.SNR,AMP.TAU,AMP.QUALITY,AMP.RFLAG,AMP.CFLAG,AMP.WSTART,AMP.DURATION,AMP.LDDATE";

/**  Table column data field names.
*/
    public static final String [] FIELD_NAMES  = {
	"AMPID", "COMMID", "DATETIME", "STA", "NET", 
	"AUTH", "SUBSOURCE", "CHANNEL", "CHANNELSRC", "SEEDCHAN", 
	"LOCATION", "IPHASE", "AMPLITUDE", "AMPTYPE", "UNITS", 
	"AMPMEAS", "ERAMP", "FLAGAMP", "PER", "SNR", 
	"TAU", "QUALITY", "RFLAG", "CFLAG", "WSTART", 
	"DURATION", "LDDATE"
    };

/** Nullable table column field.
*/
    public static final boolean [] FIELD_NULLS = {
	false, true, false, false, true, 
	false, true, true, true, true, 
	true, true, false, true, false, 
	true, true, true, true, true, 
	true, true, true, true, false, 
	false, true
    };

/**  Table column data field object class identifiers.
* @see org.trinet.jdbc.datatypes.DataClassIds
* @see org.trinet.jdbc.datatypes.DataClasses
*/
    public static final int [] FIELD_CLASS_IDS = {
	DATALONG, DATALONG, DATADOUBLE, DATASTRING, DATASTRING, 
	DATASTRING, DATASTRING, DATASTRING, DATASTRING, DATASTRING, 
	DATASTRING, DATASTRING, DATADOUBLE, DATASTRING, DATASTRING, 
	DATASTRING, DATADOUBLE, DATASTRING, DATADOUBLE, DATADOUBLE, 
	DATADOUBLE, DATADOUBLE, DATASTRING, DATASTRING, DATADOUBLE, 
	DATADOUBLE, DATADATE
    };

/**  Column indices of primary key table columns.
*/
    public static final int [] KEY_COLUMNS = {0};

/**  Number of decimal fraction digits in table column data fields.
*/
    public static final int [] FIELD_DECIMAL_DIGITS = {
	0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 4, 0, 
	4, 1, 0, 0, 0, 0, 0
    };

/** Numeric sizes (width) of the table column data fields.
*/
    public static final int [] FIELD_SIZES = {
	15, 15, 25, 6, 8, 15, 8, 3, 8, 3, 2, 8, 126, 8, 4, 1, 5, 4, 10, 126, 
	7, 2, 2, 2, 126, 126, 7
    };

/** Default table column field values.
*/
    public static final String [] FIELD_DEFAULTS = {
	null, null, null, null, null, null, null, null, null, null, 
	null, null, null, null, null, null, null, null, null, null, 
	null, null, null, null, null, null, "(SYSDATE)"
    };
}
