package org.trinet.jdbc.table;
import java.lang.*;
import java.util.*;
import java.sql.*;
import org.trinet.jdbc.*;

/**
Class queries the database using a JDBC Connection Statement for the current or next sequence numbers in named sequences.
Known sequences for the NCEDC schema are:

AMPSEQ
ARSEQ
COMMSEQ
COSEQ
EVSEQ
FILESEQ
MAGSEQ
MECSEQ
ORSEQ
WFSEQ

To get a updated list of sequence names from the database use the query:
select object_name from user_objects where object_type = 'SEQUENCE' ;
*/
public abstract class SeqIds {
    private static ResultSet rs;
    
/** Method implemented by class extensions specific to a named sequence. */
    public abstract int getNextSeq();
/** Method implemented by class extensions specific to a named sequence. */
    public abstract int getCurrSeq();
    
/** Returns the next sequence number from the database sequence with the specified input name.
* Requires an JDBConn static connection, user must first instantiate a JDBConn class object.
* Returns 0, if no such sequence exits or an SQLException occurs.
*/
    public static int getNextSeq(String name) {
	int idum=0;
	String sql = "SELECT " + name + ".NEXTVAL FROM DUAL";
	if (JDBConn.sm == null) {
	    System.out.println("SeqIds error must have created connection JDBConn");
	    return 0;
	}
	try {
	    rs = JDBConn.sm.executeQuery(sql); 
	    while ( rs.next() ) {
		idum = rs.getInt(1);
	    }
	    rs.close();
	    return idum;
	}
	catch (SQLException ex) {
	    SQLExceptionHandler.prtSQLException(ex);
	    return 0;
	}
    }
    
/** Returns the current sequence number from the database sequence with the specified input name.
* Requires an JDBConn static connection, user must first instantiate a JDBConn class object.
* Returns 0, if no such sequence exits or an SQLException occurs.
*/
    public static int getCurrSeq(String name) {
	int idum=0;
	String sql = "SELECT " + name + ".CURRVAL FROM DUAL";
	if (JDBConn.sm == null) {
	    System.out.println("SeqIds error must have created connection JDBConn");
	    return 0;
	}
	try {
	    rs = JDBConn.sm.executeQuery(sql); 
	    while ( rs.next() ) {
		idum = rs.getInt(1);
	    }
	    rs.close();
	    return idum;
	}
	catch (SQLException ex) {
	    SQLExceptionHandler.prtSQLException(ex);
	    return 0;
	}
    }

/** Returns the next sequence number from the database sequence with the specified input name.
* Uses the specified input Connection object for the database query, user must first instantiate a connection object.
* Returns 0, if no such sequence exits or an SQLException occurs.
*/
    public static int getNextSeq(Connection conn, String name) {
	int idum=0;
	String sql = "SELECT " + name + ".NEXTVAL FROM DUAL";
	try {
	    Statement sm = conn.createStatement();
	    rs = sm.executeQuery(sql); 
	    while ( rs.next() ) {
		idum = rs.getInt(1);
	    }
	    rs.close();
	    sm.close();
	    return idum;
	}
	catch (SQLException ex) {
	    SQLExceptionHandler.prtSQLException(ex);
	    return 0;
	}
    }
    
/** Returns the current sequence number from the database sequence with the specified input name.
* Uses the specified input Connection object for the database query, user must first instantiate a connection object.
* Returns 0, if no such sequence exits or an SQLException occurs.
*/
    public static int getCurrSeq(Connection conn, String name) {
	int idum=0;
	String sql = "SELECT " + name + ".CURRVAL FROM DUAL";
	try {
	    Statement sm = conn.createStatement();
	    rs = sm.executeQuery(sql); 
	    while ( rs.next() ) {
		idum = rs.getInt(1);
	    }
	    rs.close();
	    sm.close();
	    return idum;
	}
	catch (SQLException ex) {
	    SQLExceptionHandler.prtSQLException(ex);
	    return 0;
	}
    }
}
