package org.trinet.jasi.coda;

import org.trinet.jasi.*;

public interface CodaCalibrationListIF {

/** Adds to list the input parameter calibration object. */
    boolean add(CodaCalibration calibr);

/** Retrieves from list the calibration object whose ChannelID is equivalent to the input parameter. */
    CodaCalibration get(ChannelIdIF id);

/** Returns true if list contains object with ChannelID equivalent to that of input parameter. */
    boolean contains(ChannelIdIF id);

/** Returns the number of calibration objects in the list. */
    int size();

/** Clears the list of calibration objects. */
    void clear();

/** Returns true if list contains no calibration objects . */
    boolean isEmpty();

/** Returns true if list contains a calibration object equivalent to the input parameter. */
    boolean contains(CodaCalibration calibr);

/** Store data of list instance to a default data source. */
    boolean store();

/** Initialize list instance with data from a default data source. */
    boolean load();

/** Initialize list instance with data from a default data source. */
    boolean load(java.util.Date date);

/** Dump to System.out the toString() of the list values.*/
    void printValues();
}

