package org.trinet.jasi;
import org.trinet.jasi.*;

public class CodaList extends JasiReadingList {

     public CodaList() { }

/**
* Return a subset of this list containing the Coda that are associated
* with this solution. If Solution is set to null, unassociated coda will
* be returned. Deleted coda are never associated.
*/
    public JasiReadingList getAssociated(Solution sol) {
  CodaList newList = new CodaList();
  Coda coda[] = getArray();
  for (int i = 0; i<coda.length; i++) {
      if (coda[i].sol == sol) newList.add(coda[i]);
  }
  return newList;
    }

/**
* Return a subset of this list containing the Codas that are from the
* given Channel. If Solution is set to null, unassociated Codas will
* be returned.
*/
    public CodaList getAssociated(Channel chan) {
  CodaList newList = new CodaList();

  Coda coda[] = getArray();
  for (int i = 0; i<coda.length; i++) {
            ChannelName chanName = chan.getChannelName();
      if (chanName.sameAs(coda[i].getChannelObj().getChannelName())) {
         newList.add(coda[i]);
      }
  }
  return newList;
    }

/**
* Return the Coda nearest to this time. Returns null if there are none.
*/
    public Coda getNearestCoda(double time) {

  if (isEmpty()) return null;

  Coda nearest = null;
  double nearestDiff = Double.MAX_VALUE;
  double diff;

  Coda coda[] = getArray();

  for (int i = 0; i<coda.length; i++)	// inc at start to skip ph[0]
  {
      if (!coda[i].isDeleted()) {
    diff = Math.abs(coda[i].getTime() - time);

    if (diff < nearestDiff) {
        nearestDiff = diff;
        nearest = coda[i];
    }
      }
  }
  return nearest;
    }


/**
* Return the coda nearest to this time that matches this Channel.
*  Returns null if there are none.
*/
    public Coda getNearestCoda(double time, Channel chan) {
  if (isEmpty()) return null;
  Coda coda[] = getArray();
  Coda nearest = coda[0];
  double diff0 = Math.abs(nearest.getTime() - time);
  double diff;

  for (int i = 0; i<coda.length; ++i)	// inc at start
  {
      if (!coda[i].isDeleted()) {
                ChannelName chanName = chan.getChannelName();
    if (chanName.equalsIgnoreCase(coda[i].getChannelObj().getChannelName())) {

        diff = Math.abs(coda[i].getTime() - time);

        if (diff < diff0) {
      diff0 = diff;
      nearest = coda[i];
        }
    }
      }
  }

  return nearest;
    }

/** Return true if the list has codas. */
    public boolean hasCoda() {
      return !isEmpty();
    }

/**
* Substitute for ArrayList.toArray() that casts the returned object array
* as an array of type Coda.
*/
    public Coda[] getArray() {
  return (Coda[]) toArray(new Coda[this.size()]);
    }

/**
* Dump list, for debugging.
*/
    public String dumpToString() {

     String str = "";

  Coda coda[] = getArray();
  for (int i = 0; i<coda.length; i++) {
      str += coda[i].toString() + "\n";
  }

     return str;
    }

/**
* Dump list, for debugging.
*/
    public void dump() {
      System.out.println (dumpToString());
    }
/*
     public static void main(String[] args) {
          CodaList codaList = new CodaList();
     }
*/

    /** Return a string with the list of codas and
    * channelmags. */
    public String neatDump () {

  Coda coda[] = getArray();
        int size = coda.length;
        if (size == 0)  return "";

  StringBuffer strBuff = new StringBuffer(size*132);
        strBuff.append( coda[0].getNeatStringHeader());
        strBuff.append("\n");

  for (int i = 0; i<size; i++) {
      strBuff.append(coda[i].toNeatString());
            strBuff.append("\n");
  }
  return strBuff.toString();
    }

}
