
//Title:        Your Product Name
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.jasi;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import javax.swing.JFrame;

import org.trinet.util.*;
import org.trinet.util.graphics.EventSelectionDialog;

public class CatSearch extends JFrame {

       static boolean debug = true;

     public CatSearch() {

    }

    public static void main(String s[])
    {

        JFrame frame = new JFrame("Cat Search");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });


	   frame.setSize(200,30);	// this has no effect!
        frame.pack();
        frame.setVisible(true);

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource();

// Private properties

	   EventSelectionProperties props = new EventSelectionProperties("eventProperties");

        if (debug) props.dumpProperties();

        EventSelectionDialog dialog =
                 new EventSelectionDialog(frame, "Event Selection", true, props);

   while (true) {
        dialog.setVisible(true);

        if (dialog.getButtonStatus() == JOptionPane.OK_OPTION) {
           props = dialog.getEventSelectionProperties();
        }  else {
           System.exit(0);
        }

       System.out.println ("-- Event Selection Properties AFTER --");

       props.dumpProperties();

       System.out.println ("-----------");
        System.out.println ("TimeSpan = "+ props.getTimeSpan().toString());

 	SolutionList catList = new SolutionList(props);

	Solution sol[] = catList.getArray();

	//	System.out.println ("found ="+sol.length);

	if (sol.length == 0) System.out.println (" * No events found.");

	for (int i = 0; i < sol.length; i++)
	{
	    System.out.println (sol[i].toSummaryString() +" "+
				sol[i].source.toString() );
	}

   } // end while

    }
}