      SUBROUTINE OPENW (IUNIT,FIL,FOR,IOS,ACC)
C--OPEN A FILE FOR WRITING

C--THE ARGUMENTS ARE:
C  IUNIT   UNIT NUMBER (INTEGER)
C  FIL     CHAR STRING CONTAINING FILENAME
C  FOR     CHAR STRING FOR THE FORM SPECIFIER:
C            'F' OR 'FORMATTED'   ASCII FILE TO READ FORMATTED
C            'U' OR 'UNFORMATTED' BINARY FILE TO READ UNFORMATTED
C            'P' OR 'PRINT'       ASCII FILE TO WRITE WITH CARRIAGECONTROL
C                   CHARACTER
C  IOS     ERROR RETURN:
C             0    OPEN WAS OK
C             >0   AND ERROR OCCURRED
C  ACC     ACCESS SPECIFIER
C            'S' OR 'SEQUENTIAL'  NORMAL ACCESS, WRITE FROM BEGINNING OF FILE
C            'A' OR 'APPEND'      WRITE AT END OF FILE IF IT EXISTS

      CHARACTER FIL*(*), FOR*(*), ACC*(*), FSTR*12, ASTR*11, CC*9
      INTEGER IUNIT,IOS

      FSTR='formatted  '
      IF (FOR(1:1).EQ.'u' .or. FOR(1:1).EQ.'U') FSTR='unformatted  '
C--SUN & OS2
      IF (FOR(1:1).EQ.'p' .or. FOR(1:1).EQ.'P') FSTR='print  '
C--VAX
C      CC='list  '
C      IF (FOR(1:1).EQ.'p' .OR. FOR(1:1).EQ.'P') CC='FORTRAN  '

      ASTR='sequential  '
      IF (ACC(1:1).EQ.'a' .OR. ACC(1:1).EQ.'A') ASTR='append  '

C--SUN
      OPEN (IUNIT,FILE=FIL, FORM=FSTR, IOSTAT=IOS, STATUS='unknown',
     2 ACCESS=ASTR)

C--OS2
C      OPEN (IUNIT,FILE=FIL, FORM=FSTR, IOSTAT=IOS, STATUS='UNKNOWN',
C     2 ACCESS=ASTR)

C--VAX
C      OPEN (IUNIT,FILE=FIL, FORM=FSTR, IOSTAT=IOS, STATUS='NEW',
C     2 ACCESS=ASTR, CARRIAGECONTROL=CC, RECL=256)
      RETURN
      END
