#
# q3302ew - Q330 to earthworm interface
#


#gnu compiler
#CFLAGS = -g -ggdb -D_REENTRANT -DQ3302EW ${GLOBALFLAGS} 
#CC=g++

# solaris forte compiler
CFLAGS = -D_REENTRANT -DQ3302EW ${GLOBALFLAGS} 
CC=CC

B = $(EW_HOME)/$(EW_VERSION)/bin
L = $(EW_HOME)/$(EW_VERSION)/lib

QMASERV_HOME = ./Mountainair/src/qmaserv
QMA = ${QMASERV_HOME}/qmaserv
QMA_INC = ${QMASERV_HOME}/include
QMA_MSG = ${QMASERV_HOME}/msgs
QMA_UTL = ${QMASERV_HOME}/utils

EWLIB_INCLUDE = ${EW_HOME}/${EW_VERSION}/include

CFLAGS += -I${EWLIB_INCLUDE} -I${QMA_INC} -I${QMA} -I${QMA_MSG} -I${QMA_UTL} -I. #-xCC

CPPFLAGS = ${CFLAGS}

all: q3302ew

MOUNTAINAIR_SRC = 

SRCS = main.C config.C options.C die.C heart.C ${QMA}/ConfigVO.C logo.C scn_map.C \
${QMA}/TxCmd.C ${QMA}/RxMsg.C ${QMA}/CountDownTimer.C ${QMA_MSG}/Packet.C \
${QMA_MSG}/PacketElement.C ${QMA_MSG}/QDPHeader.C ${QMA_UTL}/CRC.C \
${QMA_MSG}/c1_cerr.C ${QMA_MSG}/c1_mem.C ${QMA_MSG}/c1_flgs.C ${QMA_MSG}/c1_stat.C \
${QMA}/StateMachine.C ${QMA_MSG}/Field.C ${QMA}/TokenVO.C ${QMA}/TokenBuffer.C \
${QMA}/NetStationVO.C ${QMA}/LCQVO.C ${QMA}/ClockProcVO.C ${QMA}/ConfigInfoVO.C \
${QMA}/OptionBitsVO.C ${QMA}/TimeServer.C ${QMA}/ChanFreqMap.C ${QMA}/Verbose.C \
${QMA}/LogTimingVO.C ${QMA}/DetectorOptionsVO.C ${QMA}/QMA_Port.C ${QMA_UTL}/SeqnoList.C \
${QMA}/AckCounter.C ${QMA}/SlidingWindow.C ${QMA_UTL}/TimeOfDay.C ${QMA}/PacketMarker.C \
${QMA}/Q330Version.C ${QMA_UTL}/ModuloCounter.C ${QMA}/SendCmds.C ${QMA_MSG}/c1_rqmem.C \
${QMA_MSG}/c1_srvch.C ${QMA_MSG}/c1_rqflgs.C ${QMA_MSG}/c1_rqsrv.C ${QMA_MSG}/c1_srvrsp.C \
${QMA_MSG}/c1_rqstat.C ${QMA_MSG}/c1_dsrv.C ${QMA_MSG}/c1_umsg.C ${QMA_MSG}/dt_open.C \
${QMA}/qmautils.C ${QMA}/ReceiveMsgs.C ${QMA_MSG}/c1_fix.C ${QMA_MSG}/c1_log.C \
${QMA_MSG}/c1_sc.C ${QMA_MSG}/c1_sglob.C ${QMA}/PCQ.C ${QMA}/LCQ.C ${QMA}/SecondOfData.C \
${QMA}/Blockette.C ${QMA}/ProcessIQ.C ${QMA_MSG}/dt_dack.C ${QMA_MSG}/dt_data.C \
${QMA}/QueueDP.C ${QMA_UTL}/findMD5.C ${QMA}/Cleanup.C ${QMA_UTL}/md5.C ${QMA}/CreatePacket.C \
${QMA}/ProcessDCComp.C ${QMA_UTL}/CharUtils.C ${QMA}/ClockUtils.C ${QMA_UTL}/UnpackComp.C \
${QMA}/FrameUtils.C ${QMA}/ProcessDCMult.C ${QMA}/ProcessDCD32.C ${QMA}/CheckPCQS.C \
${QMA}/CheckLCQS.C ${QMA}/SplitSOD.C ${QMA_UTL}/Logger.C ${QMA_UTL}/qmaswap.C\
${QMA}/ProcessMN816.C ${QMA}/ProcessAG38.C ${QMA}/ProcessMN232.C ${QMA}/ProcessMN38.C \
${QMA}/ProcessAG816.C ${QMA}/TypeChanFreqMap.C

OBJS = $(SRCS:%.C=%.o)

.C.o:
#	$(CC) $(CFLAGS) -c  $(@F:.o=.C) -o $@ 
	$(CC) $(CFLAGS) -c  $< -o $@ 


EW_LIBS = \
	$L/getutil.o \
	$L/transport.o \
	$L/kom.o \
	$L/logit_mt.o \
	$L/sema_ew.o \
	$L/threads_ew.o \
	$L/time_ew.o \
	$L/sleep_ew.o \
	$L/socket_ew.o \
	$L/socket_ew_common.o \

q3302ew: $(OBJS); \
        $(CC) -o $(B)/q3302ew $(OBJS) $(EW_LIBS) -L$(QMA) -lc -lsocket -lnsl -lposix4 -lthread -lm #-lutil

# Clean-up rules
clean:
	#rm -f a.out core *.o *.obj *% *~
	find . -name '*.o' -exec rm {} \;
clean_bin:
	rm -f $B/q3302ew*

FORCE:
