#ifndef _EXTERNS_H_
#define _EXTERNS_H_

#ifndef EXTERN
#  define EXTERN extern
#endif


#ifndef _WINNT
#include <time.h>
#endif 

#ifndef Q3302EW
#include <sys/shm.h>	
#endif

#include "ConfigVO.h"

extern "C" {
#  include "transport.h" 	/* needed for MSG_LOGO typedef */
};
/****************************************************************/
/* 
	Put all external variables here.
        NOTE: All extern vars start with a capital letter
*/


EXTERN int ShutMeDown;		/* shut down flag */
EXTERN char * Config;		/* config file name */


/****************************************************************/
/* EarthWorm global configs : all of these are REQUIRED from the config/desc
        file
*/


EXTERN unsigned char QModuleId;         /* module id for q3302ew */


/* some globals for EW not settable in the .d file. */

EXTERN pid_t    MyPid;
EXTERN SHM_INFO  Region;  
EXTERN MSG_LOGO DataLogo;               /* EW logo tag  for data */
EXTERN MSG_LOGO OtherLogo;              /* EW logo tag  for err,log,heart */
EXTERN unsigned char TypeTrace;         /* Trace EW type for logo */
EXTERN unsigned char TypeHB;            /* HB=HeartBeat EW type for logo */
EXTERN unsigned char TypeErr;           /* Error EW type for logo */

EXTERN time_t	TSLastBeat;		/* time stamp since last heartbeat */
EXTERN unsigned TidHB;			/* ID for the hearbeat thread */
EXTERN time_t   g_jan2000;              /* local epoch */

EXTERN int g_currentClockQuality;
#endif
