package org.trinet.util.magnitudeengines;
import java.util.*;
import org.trinet.jasi.coda.TN.*;
import org.trinet.jasi.TN.*;
import org.trinet.jasi.coda.*;
/** To calculate time series amplitude coda decay data and get results in a CodaTN object. */
public class McaCodaGeneratorTN extends CodaGeneratorTN {

    public static final String  DEFAULT_ALGORITHM              = "MCA";

    public static final int     DEFAULT_NOISE_AVE_CALC_SAMPLES = 1000;

    public static final int     DEFAULT_MIN_GOOD_WINDOWS       = 2;
    public static final int     DEFAULT_MAX_GOOD_WINDOWS       = 20;

    public static final double  DEFAULT_QFIX                   = 1.8;

    public static final double  DEFAULT_CODA_START_SNR         = 3.0;
    public static final double  DEFAULT_CODA_CUTOFF_SNR        = 1.5;
    public static final double  DEFAULT_PASS_THRU_NSR          = 1.8;

    public static final boolean DEFAULT_RESET_ON_CLIP          = false;

    public McaCodaGeneratorTN () {

        initBuffers(DEFAULT_MAX_GOOD_WINDOWS);

        this.algorithm                         = DEFAULT_ALGORITHM;

        this.noiseBiasSamples                  = DEFAULT_NOISE_AVE_CALC_SAMPLES;  // optionally set by method input
        this.minGoodWindowsToEndCalcOnClipping = DEFAULT_MIN_GOOD_WINDOWS;    // optionally set by method input
        this.codaStartSignalToNoiseRatio       = DEFAULT_CODA_START_SNR;      // optionally set by method input
        this.codaCutoffSignalToNoiseRatio      = DEFAULT_CODA_CUTOFF_SNR;     // optionally set by method input
        this.passThruNoiseDecayAmpRatio        = DEFAULT_PASS_THRU_NSR;       // optionally set by method input
        this.qFix                              = DEFAULT_QFIX;                // optionally set by method input
        this.resetOnClipping                   = DEFAULT_RESET_ON_CLIP;       // optionally set by method input

    }

    protected CodaTN timeAmpsToResults(CodaTN resultsCoda) {
        Collection timeAmpPairs = resultsCoda.getWindowTimeAmpPairs();
        TimeAmp [] timeAmps = getGoodWindowTimeAmps();
        int size = timeAmps.length;
        if (size > 0) {
            timeAmpPairs.add(timeAmps[0]);
            if (size > 1) timeAmpPairs.add(timeAmps[size-1]);
        }
        else timeAmpPairs.add(new TimeAmp(getWindowTauSeconds(0), firstWindowAveAbsAmp));
        return resultsCoda;
    }

    protected double getWindowWeight(double tauCurrentWindow, double averagedAbsAmp) {
  double weight = 1.0;
  if (averagedAbsAmp < minCodaStartingAmp) {
             weight = (averagedAbsAmp - maxCodaNoiseCutoffAmp)/(minCodaStartingAmp - maxCodaNoiseCutoffAmp);
        }
        return (100.*weight)/(tauCurrentWindow*tauCurrentWindow);
    }

    protected double getWindowTauSeconds(int windowCount) {
        return secsPastPTimeAtStartingIdx + ((double) windowCount)*windowSize;
    }
}
