package Tester;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.trinet.jasi.*;
import org.trinet.util.graphics.task.*;

/** Example of progress monitorable Ml task using stand alone dialogs as a GUI. */
public class MlProgressTester {
    static Solution sol;
    static Collection waveList;
    //static Magnitude magnitude;

    public static final void main(String [] args) {
        System.out.println("Creating new database connection");
        final DataSource dataSource = new DataSource(
       "jdbc:oracle:thin:@makalu.gps.caltech.edu:1521:makaludb",
       "oracle.jdbc.driver.OracleDriver",
       "trinetdb",
       "calgs"
        ); // use defaults

        try {
        System.out.println("Creating new ml thread group");
        final ThreadGroup jiggleThreadGroup = new ThreadGroup("JiggleML");
        jiggleThreadGroup.setDaemon(false);

        final int id = 10983128;  // a random test event

        MlProgressTester.sol = Solution.create().getById(id);
        MlProgressTester.waveList = Waveform.create().getBySolutionId(id);

// EXAMPLE progress bar monitor
        System.out.println("Waiting for channelList, loading to complete");
        // Now let's Load channelList by measured progress thread
        ChannelList channelList = null;
        MonitorableChannelListTask channelTask = 
            new MonitorableChannelListTask() {
                public void finished() {
                    System.out.println("Finished channelList load count: " + ((Collection) getTaskResult()).size()); 
                }
            };

        channelTask.setThreadGroup(jiggleThreadGroup);
        channelTask.setThreadName("ChannelList");
        channelTask.setProgressTimerDelay(100);

        //ChannelListLoaderDialog channelDialog = new ChannelListLoaderDialog();
        TaskMonitorDialog channelDialog = new TaskMonitorDialog();
        channelDialog.setTask(channelTask);
        channelDialog.setProgressMeterVisible(true);
        channelDialog.setLocation(0,0);
        channelDialog.startTask();

        // System.out.println("MAIN: threads running: " + jiggleThreadGroup.activeCount()); //DEBUG
        //jiggleThreadGroup.list(); // DEBUG

        // block here til channel loading thread is done
        channelList = (ChannelList) channelTask.getTaskResult();

// EXAMPLE2 progress bar monitor
        //System.out.println("Created a solution the channelList and the waveformList, creating magnitude task ...");
        final MonitorableMlTask mlTask = 
            new MonitorableMlTask("ML", new MagnitudeEngine(new SoCalML()), channelList) {
                public void finished() {
                    System.out.println(Magnitude.getNeatStringHeader());
                    Magnitude magnitude = (Magnitude) getTaskResult();
                    System.out.println(magnitude.toNeatString());
                }
            };
        mlTask.setThreadGroup(jiggleThreadGroup);
        mlTask.setThreadName("ML");
        mlTask.configureMagEngine(1.0, 1.2, false, true);
        mlTask.setSolutionData(sol, waveList);
        mlTask.setProgressTimerDelay(1000);

        //System.out.println("Created a solution the channelList and the waveformList, creating task dialog ...");
        TaskMonitorButtonBoxDialog mlDialog = new TaskMonitorButtonBoxDialog();
        mlDialog.setTask(mlTask);
        mlDialog.setProgressMeterVisible(true);
        mlDialog.setLocation(50,100);
        TaskCompletedListener tcListener =
             new TaskCompletedListener() { 
                 public void taskCompleted(TaskCompletedEvent taskEvent) {
                     //System.out.println("Listener invoked mag: " + ((Magnitude) mlTask.getTaskResult()).toString() + "\n");
                     // System.out.println("MAIN: threads running: " + jiggleThreadGroup.activeCount());
                     // jiggleThreadGroup.list(); // DEBUG
                     jiggleThreadGroup.interrupt();
                     System.out.println("Exit ML processing at: " + new Date(System.currentTimeMillis()).toString());
                 }
             };
        mlDialog.addTaskCompletedListener(tcListener);
        System.out.println("Starting ML processing at: " + new Date(System.currentTimeMillis()).toString());
        final JButton exitButton = new JButton("Exit");
        exitButton.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                System.out.println("Received exit event for Dialog");
                Dialog dialog = (Dialog) exitButton.getRootPane().getParent();
                dialog.setVisible(false);
                dialog.dispose();
                dataSource.close();
                System.exit(0);
            }
        });
        mlDialog.getContentPane().add(exitButton);
        mlDialog.pack();
        mlDialog.startTask();
        }
        catch (Exception ex ) {
            ex.printStackTrace();
            dataSource.close();
            System.exit(0);
        }
    }
}
