package org.trinet.util.gazetteer.TN;
import org.trinet.util.gazetteer.*;
public class GazetteerType {
    public static final GazetteerType TOWN = new GazetteerType(10, "town");
    public static final GazetteerType BIG_TOWN = new GazetteerType(12, "bigTown");
    public static final GazetteerType QUARRY = new GazetteerType(30, "quarry");
    public static final GazetteerType QUAKE = new GazetteerType(40, "quake");
    public static final GazetteerType PLACE = new GazetteerType(500, "place");
    public static final GazetteerType STATION = new GazetteerType(501, "station");
    public static final GazetteerType LANDFORM = new GazetteerType(600, "landform");
    public static final GazetteerType FAULT = new GazetteerType(601, "fault");

    private final long code; 
    private final String name; 

    private GazetteerType(long code, String name) {
	this.code =  code;
	this.name =  name;
    }
    public long getCode() {
	return code;
    }
    public String getName() {
	return name;
    }
    public boolean equals(Object object) {
	if (object == null || ! (object instanceof GazetteerType)) return false;

	if (getCode() == ((GazetteerType) object).getCode()) { 
	    if (getName().equals(((GazetteerType) object).getName())) return true; 
	}
	return false;
    }

    public String toString() {
	return String.valueOf(code) + " " + name;
    }
}
