package org.trinet.storedprocs.association;
import java.sql.*;
import org.trinet.jasi.*;
import org.trinet.util.*;
import org.trinet.util.gazetteer.LatLonZ;  /// LatLonZ

/**
 * Title:        Your Product Name
 * Description:  Your description
 * Copyright:    Copyright (c) 2001
 * Company:      USGS
 * @author Doug Given
 * @version
 */

public class AmpAssoc {

  static final boolean debug = true;

  static double searchTimeWindow = 120.0; // secs
//  static ampAssocModelIF assocModel;
  static TravelTime ttModel = TravelTime.getInstance();

  /** Mag engine to calc ChannelMag as a test that the amp is consistent with
   *  the associated event.  */
  static MagnitudeEngine magEng = new MagnitudeEngine(new SoCalML());

  static Connection conn;

  public AmpAssoc() {
  }

  /** Return the event ID for this Amplitude. Returns 0 if no match.
   *  Assumes WAU amp type in units of mm. */
  public static long getAssocEvent(long ampid) {
     return getAssocEvent(Amplitude.create().getById(ampid));
  }

  /** Return the event ID for this Amplitude. Returns 0 if no match.
   *  Assumes WAU amp type in units of mm. */
  public static long getAssocEvent(String net,
				   String sta,
				   String seedchan,
				   String loc,
				   double amptime,
				   double ampvalue) {
// make an amp
     Amplitude amp = Amplitude.create();
     // note we put seedchan in channel also!
//     amp.setChannelObj(new Channel(net, sta, seedchan, null, null, null, seedchan, loc));

     amp.setChannelObj(Channel.create().setChannelName(net, sta, seedchan, null, null, null, seedchan, loc));
      // look up latlonz
      amp.setChannelObj(Channel.lookUp(amp.getChannelObj()));
     amp.setTime(amptime);
     amp.setType(AmpType.WAU);
     amp.units = Units.MM;

     if (debug)  System.out.println(amp.toString());

     return getAssocEvent(amp);

  }
  /** Return the event ID for this Amplitude. Returns 0 if no match. */
  public static long getAssocEvent(Amplitude amp) {
    LatLonZ llz = amp.getChannelObj().latlonz;
    return PointAssociator.getAssocEvent(llz.getLat(), llz.getLon(),
					 llz.getZ(), amp.getTime());
  }

  /*

      if (amp == null) return 0;

      long matchID = 0;

      double windowSlop = 5.0; // increase window size by this to account for
			       // ampgen window size

      double startTime = amp.getTime() - searchTimeWindow;
      double endTime   = amp.getTime();

      makeConnection(); // this makes static method "standalone"

      // get candidate events
      SolutionList solList = new SolutionList();
      solList.setConnection(DataSource.getConnection());
      solList.fetchValidByTime(startTime, endTime);

      if (debug) System.out.println("Events found = "+   solList.size());
      if (solList.isEmpty()) return matchID;  // nothing

      // make sure channel is "set up" with latlonz and gain
      if (!amp.getChannelObj().hasLatLonZ() || amp.getChannelObj().gain.isNull())
	      amp.setChannelObj(Channel.lookUp(amp.getChannelObj()));

      if (!amp.getChannelObj().hasLatLonZ()) return 0;  // no location

      LatLonZ llzAmp = amp.getChannelObj().latlonz;

      Solution sol;
      double closestfit = Double.MAX_VALUE;
      double sDelta;  // difference between amp time and S-time (neg. if amp before S)
      double hotzone, ot;
      DoubleRange psrange;

      for (int i = 0; i < solList.size(); i++ ) {
	 sol = (Solution) solList.get(i);
	 ot = sol.datetime.doubleValue();

	 amp.setDistance(llzAmp.distanceFrom(sol.getLatLonZ()));

	 // tt model returns time relative to OT
	 psrange = ttModel.getTTps(amp.getDistance());

	 if (amp.getTime() < (psrange.getMinValue()+ot)) break;  // amp before P

	 sDelta = (psrange.getMaxValue() + ot) - amp.getTime() ; // S - amp
	 sDelta = Math.abs(sDelta);

	 // TEST 1: is amp in the allowable window (hotzone)
	 // hotzone is S-P time + slop value
	 hotzone = psrange.doubleExtent() + windowSlop;   // S - P

	 if (debug) System.out.println("hotzone= "+hotzone+" sDelta = "+sDelta);
	 if (sDelta < hotzone) {    // within S-P either side of S-arrival
	    if (sDelta < closestfit) matchID = sol.getId().longValue();  // closer than closest
	 }

	// TEST 2: does amp fit expected for mag and dist?
// THIS IS NOT COMPLETE -- SHOULD COMBINE WITH ABOVE TO CALC SCORE FOR MATCH
//	 amp = magEng.calcChannelMag (sol, amp);
//	 double magError = amp.channelMag.value.doubleValue() - sol.magnitude.value.doubleValue();
//	 if (debug) System.out.println("magError= "+magError);

      }

      return matchID;
  }
*/
  /**
   * Make a connection. If we are running in the context of the Oracle server,
   * make the "default" connection to the local environment. Otherwise, use
   * the hardwired info which is used for testing outside the server.
   */

    public static Connection makeConnection ()
    {
            // set the jasi universal connection object
      if (DataSource.getConnection() == null) {
	  DataSource.set(DbaseConnection.create());
      }
      return conn;
    }

  public static void main(String[] args) {

    //long id = 56998981;
    long evid = 12475624;

    makeConnection();

//    Amplitude amp = Amplitude.create().getById(id);

    AmpList ampList = Amplitude.create().getBySolution(evid);
    Amplitude amps[] = ampList.getArray();

 //      System.out.println(amp.toString());
 //      long evid = getAssocEvent(amp);
 //      System.out.println("Result: evid = "+ evid);

    for (int i = 0; i< amps.length; i++) {
       System.out.println(amps[i].toString());
//       long result = getAssocEvent(amps[i]);
       Channel ch = amps[i].getChannelObj();
//       Channel ch = Channel.lookUp(amps[i].getChannelObj());
       long result = getAssocEvent(ch.getNet(), ch.getSta(), ch.getSeedchan(), ch.getLocation(),
			           amps[i].getTime(), amps[i].value.doubleValue());
       System.out.println("Result: evid = "+ result);
    }
  }
}