package org.trinet.pcs;

  /**
   * Structure of the Transition Table
   */

//package ProcessControlSystem;

import java.sql.*;
import java.util.*;

/**
 * Represents rows in the the PCS_Transition Table
 */
public class TransitionRow
{
  public String controlGroup;		// NOT NULL
  public String sourceTable;		// NOT NULL
  public String stateOld;		// NOT NULL
  public int	 result;
  public String stateNew;
  public int    rank;
  public String auth;			// NOT NULL
  public String subsource;
  public java.sql.Date lddate;

  public TransitionRow() {};

  /**
   * Insert row for this Transition into the dbase
   */
  public int insert ()
    {
      String sql = "INSERT into "+ProcessControl.TransitionTable+" ("+
	fieldString() +
	" , lddate) values (" +
	toValueString() + 
	", SYSDATE)" ;
      
      return doUpdate (sql);

    }

  /**
   * Delete this row
   */
  public int delete ()
    {
      String sql = "Delete from "+ProcessControl.TransitionTable+" where "+
	" controlGroup = '"+controlGroup+"'"+
	" and sourceTable = '"+sourceTable+"'"+
	" and stateOld = '"+stateOld+"'"+
	" and result = "+ result;

      return doUpdate (sql);

    }

  /**
   * Delete rows
   */
  public static int delete (String cGroup, String sTable, String state)
    {
      String sql = "Delete from "+ProcessControl.TransitionTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+sTable+"'"+
	" and stateOld = '"+state+"'";

      return doUpdate (sql);

    }
  /**
   * Delete rows
   */
  public static int delete (String cGroup, String sTable)
    {
      String sql = "Delete from "+ProcessControl.TransitionTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+sTable+"'";

      return doUpdate (sql);

    }
  /**
   * Delete rows
   */
  public static int delete (String cGroup)
    {
      String sql = "Delete from "+ProcessControl.TransitionTable+" where "+
	" controlGroup = '"+cGroup+"'";

      return doUpdate (sql);

    }

  public static TransitionRow[] 
	get(String cGroup, String cTable, String state)
    { 
      String sql = 
	"SELECT * from "+ProcessControl.TransitionTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" and stateOld = '"+state+"'"+
	" order by controlGroup, sourceTable, stateOld, stateNew DESC";

      return doQuery(sql);
    }

  public static TransitionRow[] get(String cGroup, String cTable)
    { 
      String sql = 
	"SELECT * from "+ProcessControl.TransitionTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" and sourceTable = '"+cTable+"'"+
	" order by controlGroup, sourceTable, stateOld, stateNew DESC";

      return doQuery(sql);
    }

  public static TransitionRow[] get(String cGroup)
    { 
      String sql = 
	"SELECT * from "+ProcessControl.TransitionTable+" where "+
	" controlGroup = '"+cGroup+"'"+
	" order by controlGroup, sourceTable, stateOld, stateNew DESC";

      return doQuery(sql);
    }

  public static TransitionRow[] get()
    { 
      String sql = 
	"SELECT * from "+ProcessControl.TransitionTable+""+
	" order by controlGroup, sourceTable, stateOld, stateNew DESC";

      return doQuery(sql);
    }

  public String toString()
    {
    	return 
	controlGroup + ", " +
	sourceTable + ", " +
	stateOld + ", " +
	znull(result) + ", " +
	stateNew + ", " +
	znull(rank) + ", " +
	auth + ", " +
	subsource ; 
    } 

  public String toOutputString()
    {
    	return 
	controlGroup + " " +
	sourceTable + " " +
	stateOld + " " +
	znull(result) + " " +
	stateNew + " " +
	znull(rank) + " " +
	auth + " " +
	subsource ; 
    } 

  public static void dump (TransitionRow tr[])
    {
      if (tr == null) 
	{ 
	  System.out.println (" * No entries *");
	  return;
	}
      for (int i=0; i < tr.length; i++)
	{
	  System.out.println (tr[i].toOutputString());
	}      
    }

  public String fieldString()
    {
      return "controlGroup, sourceTable, stateOld, result, stateNew," +
	" rank, auth, subsource";
    }
/** 
 * Convert data members to a comma delimited list for use with 
 * INSERT and UPDATE.
 * Note that 'lddate' is not included 
 */
  public String toValueString()
    {
	return 
	  "'"+ controlGroup + "', " +
	  "'"+ sourceTable + "', " +
	  "'"+ stateOld + "', " +
	  znull(result) + ", " +
	  "'"+ stateNew + "', " +
	  znull(rank) + ", " +
	  "'"+ auth + "', " +
	  "'"+ subsource+"'" ;
    } 

  /**
   * Return all Process Table rows that satisfy this 'sql' query
   */
  public static TransitionRow[] doQuery (String sql)
    { 
      ResultSet rs;
      int nrows = 0;
      TransitionRow row;
      Vector v = new Vector() ;

      ProcessControl.makeConnection(); // use existing or make new connection

      try {

	Statement stmt = ProcessControl.conn.createStatement();

	rs = stmt.executeQuery(sql);

	while ( rs.next() ) {
	  row = TransitionRow.parse(rs);
	  if (row == null) break;
	  v.addElement((Object) row);
	  nrows++;
	}

	stmt.close();		//closes statement & resultset

      } catch (SQLException ex) {
	ex.printStackTrace(System.out);
	return null;
      }
      
      if ( v.size() > 0) {
	TransitionRow tr[] = new TransitionRow [nrows];
	v.copyInto(tr);
	return tr;
      }
      else {
	return null;
      }
      
    }

  public static int doUpdate(String sql)
    {
      ProcessControl.makeConnection();

      int nrows = 0;
      try {
	Statement stmt = ProcessControl.conn.createStatement();
	nrows = stmt.executeUpdate(sql);
	ProcessControl.conn.commit();
	stmt.close(); 
      }
      catch (SQLException ex) {
	ex.printStackTrace(System.out);
	System.err.println("SQL: " + sql);
      }

      return nrows;
    }


  /** Parse resultset into this TransitionRow */  
  public static TransitionRow parse (ResultSet rs)
    {
       TransitionRow tr = new TransitionRow();
        try {
	  tr.controlGroup	= getStringSafe(rs, "controlGroup");
	  tr.sourceTable	= getStringSafe(rs, "sourceTable");
	  tr.stateOld		= getStringSafe(rs, "stateOld");
	  tr.result		= rs.getInt("result");
	  tr.stateNew		= getStringSafe(rs, "stateNew");
	  tr.rank		= rs.getInt("rank");

	  tr.auth		= getStringSafe(rs, "auth");
	  tr.subsource		= getStringSafe(rs, "subsource");
	  tr.lddate      	= rs.getDate("lddate");
	  
	} catch ( NullPointerException ex) {
            System.err.println("NullPointerException in parseResults");
            ex.printStackTrace(System.err);
	    return null;
        } catch ( SQLException ex) {
            System.err.println("SQLException");
            ex.printStackTrace(System.err);;
	    return null;
        }

	return tr;
    }

/** 
 * Allow safe building of INSERT and UPDATE commands when some fields can be null 
 */
    public static String znull(float val)
    {
        if (val == 0.0) return "NULL";
        return String.valueOf(val);
    }

    public static String znull(int ival)
    {
        if (ival == 0) return "NULL";
        return String.valueOf(ival);
    }
    static String getStringSafe(ResultSet rs, String column)
    {
        try{
            String str = rs.getString(column);
            if (str == null) return "";
            return str;
        } catch ( NullPointerException ex) {
            System.err.println("NullPointerException");
            ex.printStackTrace(System.err);
            return "";
        } catch ( SQLException ex) {
            System.err.println("SQLException");
            ex.printStackTrace(System.out);
            return "";
        }
    }



}
