//  ProcessingControllerIF  implements by any id Processor
package org.trinet.pcs;
public interface ProcessingControllerIF {
    //static final String PCS_GET_ALL_IDS_FOR_PROCESSING_FUNCTION;
    static final String PCS_GET_NEXT_ID_FOR_PROCESSING_FUNCTION   = "{? = call PCS.getNext( ?, ?, ?) }";
    static final String PCS_RESULT_ID_PROCESSING_FUNCTION         = "{call PCS.putResult( ?, ?, ?, ?, ?) }";
    static final String PCS_POST_ID_FOR_PROCESSING_FUNCTION       = "{call PCS.putState( ?, ?, ?, ?, ?) }";

    void sleep() ;
    void sleep(int millisecs) ;
    void setDefaultSleepTimeMillis(int millisecs) ;

    java.sql.Connection getConnection() ;
    void setConnection(java.sql.Connection connection) ;
    void closeProcessing();

    boolean isValidId(long id);
    boolean isValidRank(int rank);

    void setDefaultGroupName(String stateName) ;
    String getDefaultGroupName() ;
    void setDefaultThreadName(String threadName) ;
    String getDefaultThreadName() ;
    void setDefaultStateName(String stateName) ;
    String getDefaultStateName() ;

    ProcessControlIdentifier getDefaultProcessControlIdentifier();
    void setDefaultProcessControlIdentifier(ProcessControlIdentifier pcId);
    void setDefaultProcessControlIdentifier(String groupName, String threadName, String stateName);

    long getNextId() ;
    long getNextId(String groupName, String threadName, String stateName) ;
    long getNextId(ProcessControlIdentifier pcId);

    int processNextId() ;
    int processId(long id) ;
    int processIds();

    // implement methods to post and process by time range in lieu of id processing
    int processIds(ProcessControlIdentifier pcId, int rank, org.trinet.util.DateRange dateRange);
    int processIds(String groupName, String threadName, String stateName, int rank, double startTime, double endTime) ;
    //int postIds(ProcessControlIdentifier pcId, int rank, org.trinet.util.DateRange dateRange);
    //int postIds(String groupName, String threadName, String stateName, int rank, double startTime, double endTime) ;

    int postId(long id, String groupName, String threadName, String stateName, int rank) ;
    int postId(long id, ProcessControlIdentifier pcId, int rank) ;

    int resultId(long id, int resultCode) ;
    int resultId(long id, String groupName,  String threadName, String stateName, int resultCode) ;
    int resultId(long id, ProcessControlIdentifier pcId, int resultCode) ;

}

