package org.trinet.map;

import org.trinet.jasi.*;

import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.*;
import java.io.IOException;
import java.util.*;
import java.net.URL;
import javax.swing.ImageIcon;

import com.bbn.openmap.*;
import com.bbn.openmap.util.*;
import com.bbn.openmap.layer.*;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.LayerStatusEvent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.omGraphics.*;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;

//import com.bbn.openmap.layer.EarthquakeLayer;

/**
 * Title:        Map module
 * Description:  Based on OpenMap http://openmap.bbn.com/
 * Copyright:    Copyright (c) 2001
 * Company:      USGS
 * @author Doug Given
 * @version
 */
//*** ERROR ***
//No property "station.locationHandlers" found in application properties.
//*************

//public class StationMapLayer extends EarthquakeLayer {
//public class StationMapLayer extends Layer {

public class StationMapLayer extends com.bbn.openmap.layer.location.LocationLayer {

  ChannelableList chanList;

    protected OMGraphicList omgraphics = new OMGraphicList();
    protected Color lineColor = Color.red;
    //protected boolean showingInfoLine = false;
    //protected boolean working = false;
    //protected boolean cancelled = false;
    //protected QuakeWorker currentWorker = new QuakeWorker();
    /** The layer GUI. */
    //protected JPanel gui = null;
    /** Reference to the current map projection. */
    protected Projection projection;

//    protected final static transient URL redURL =
//      StationMapLayer.class.getResource("red.gif");
//    public final static transient ImageIcon redIcon =
//      new ImageIcon(redURL, "redgif");

// initializer
    {
        setName("Station Layer");
    }

  public StationMapLayer() {
    super();
    System.out.println("Creating StationMapLayer");

        System.out.println ("Making connection... ");
	DataSource dbase = new TestDataSource();
	System.out.println (dbase.toString());

	String comps[] = {"EHZ"};
	ChannelableList clist = Channel.create().getByComponent(comps);

	setChannelList(clist);

         System.out.println (clist.toString());
  }

    public void setChannelList (ChannelableList channelableList) {
        chanList = channelableList;
    }
    public ChannelableList getChannelList() {
      return chanList;
    }


    /**
     * Paints the layer.
     * @param g the Graphics context for painting
     */
    public synchronized void paint (java.awt.Graphics g) {
	if (omgraphics != null){
	    omgraphics.render(g);
	}
    }

    /**
     * ProjectionListener interface method.
     * @param e ProjectionEvent
     */
    public void projectionChanged (ProjectionEvent e) {

	Projection newP = e.getProjection();
	if (newP.equals(projection)) {// projection not really different
	    repaint();
	    return;
	}
	projection = newP.makeClone();

	computeLayer();
    }

    /**
     * Bring the layer into sync with the current state of the map.
     */
    protected synchronized void computeLayer () {
	if (projection == null) return;

	// only do work if the layer is visible
	if (isVisible()) {
	    generateGraphics();
	    repaint();
	}
    }
    /**
     * Create the graphics.
     */
    protected void generateGraphics () {
	OMCircle circ;
	OMText text;

	int symbol_w = 5;
	int symbol_h = 5;

	if (getChannelList() == null) return;
	Channelable chan[] = chanList.getChannelableArray();

	// only do once
	if (omgraphics.size() == 0) {
	    for (int i=0; i<chan.length; i++) {

		// grouping
		OMGraphicList group = new OMGraphicList(2);

		// XY-Circle at LatLonPoint
		//circ = new OMCircle(llData[i], llData[i+1], circle_w, circle_h);
		float lat = (float) chan[i].getChannelObj().latlonz.getLat();
		float lon = (float) chan[i].getChannelObj().latlonz.getLon();

		circ = new OMCircle(lat, lon, symbol_w, symbol_h);
		circ.setLinePaint(lineColor);
		group.add(circ);

//		OMRaster sym = new OMRaster(lat, lon, redIcon);
//		group.add(sym);

		// Info
		text = new OMText(lat, lon, 0, symbol_h+10,
			  chan[i].getChannelObj().toDelimitedSeedString(),
				  java.awt.Font.decode("SansSerif"),
				  OMText.JUSTIFY_CENTER);
		text.setLinePaint(lineColor);
		group.add(text);

		group.setAppObject(new Integer(i));//remember index
		omgraphics.add(group);
	    }
	}

//	omgraphics.generate(projection, false);
	omgraphics.generate(projection, true);
    }

  }