package org.trinet.jasi.coda;
/* Historical MCA coda parameters
   PARAMETER QFIX    = 1.8             ! default value
   PARAMETER MAXSEG  = 20              ! max good windows
   PARAMETER KLIP    = 360             ! clipping amp
   PARAMETER MINVALS = 3               ! min readings, if(nmags >= MINVALS) then do summary mag
   NBYT              = 5.12/DT         ! samples per window 
   THRHI             = 3.0*KLTA + 6.0  ! starting level
   THRLO             = 0.5*THRHI       ! background cutoff noise level
   if (XAMP < 1.2*THRLO) ...           ! 1.8 xlast pass thru else stop processing coda
*/

import java.io.*;
import java.util.*;

// Temporarily until best deployment option decided.
/** CodaGenerator algorithm parameters. */
public class CodaGeneratorParms {
    public static final double QFIX_DEFAULT = 1.8;
    public static final CodaGeneratorParms SOCAL_CUSP    = new CodaGeneratorParms(false, 2, 20, 3., 1.8, 1.5, 5.12, QFIX_DEFAULT); 
    public static final CodaGeneratorParms SOCAL_TEST    = new CodaGeneratorParms(false, 2, 20, 3., 1.5, 1.8, 2.00, QFIX_DEFAULT); 
    public static final CodaGeneratorParms SOCAL_DEFAULT = new CodaGeneratorParms(false, 2, 60, 3., 1.5, 1.3, 2.00, QFIX_DEFAULT); 

    public boolean resetOnClipping;
    public int     minGoodWindowsToTerminateCoda;
    public int     maxGoodWindowsToTerminateCoda;
    public double  minSNRatioCodaCutoff;
    public double  minSNRatioForCodaStart;
    public double  passThruNSRatio;
    public double  windowSize;
    public double  qFix;

    public CodaGeneratorParms( boolean resetOnClipping, 
                        int minGoodWindows, int maxGoodWindows,
                        double snrStart, double snrCutoff,
                        double passThruNSRatio, 
                        double windowSize, double qFix
                      ) {
        this.resetOnClipping                   = resetOnClipping;
        this.minGoodWindowsToTerminateCoda     = minGoodWindows;
        this.maxGoodWindowsToTerminateCoda     = maxGoodWindows;
        this.minSNRatioCodaCutoff              = snrCutoff;
        this.minSNRatioForCodaStart            = snrStart;
        this.passThruNSRatio                   = passThruNSRatio;
        this.windowSize                        = windowSize;
        this.qFix                              = qFix;
    }

    public boolean load() {
        Properties props = new Properties();
        boolean retVal = false;
        try {
            InputStream inStream = new BufferedInputStream( new FileInputStream("codaGeneratorParms.properties"));
            props.load(new BufferedInputStream( new FileInputStream("codaGeneratorParms.properties")));
            inStream.close();

            String tmpStr = props.getProperty("resetOnClipping", String.valueOf(false));
            resetOnClipping = Boolean.valueOf(tmpStr).booleanValue();
            tmpStr = props.getProperty("minGoodWindowsToTerminateCoda", String.valueOf(20));
            minGoodWindowsToTerminateCoda = Integer.parseInt(tmpStr);
            tmpStr = props.getProperty("maxGoodWindowsToTerminateCoda", String.valueOf(20));
            maxGoodWindowsToTerminateCoda = Integer.parseInt(tmpStr) ;
            tmpStr = props.getProperty("minSNRatioCodaCutoff", String.valueOf(1.5));
            minSNRatioCodaCutoff = Float.parseFloat(tmpStr);
            tmpStr = props.getProperty("minSNRatioForCodaStart", String.valueOf(2.8));
            minSNRatioForCodaStart = Float.parseFloat(tmpStr);
            tmpStr = props.getProperty("passThruNSRatio", String.valueOf(1.8));
            passThruNSRatio = Float.parseFloat(tmpStr);
            tmpStr = props.getProperty("windowSize", String.valueOf( 5.12));
            windowSize = Float.parseFloat(tmpStr);
            retVal = true;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(132);
        sb.append(resetOnClipping).append(" ");
        sb.append(minGoodWindowsToTerminateCoda).append(" ");
        sb.append(maxGoodWindowsToTerminateCoda).append(" ");
        sb.append(minSNRatioForCodaStart).append(" ");
        sb.append(minSNRatioCodaCutoff).append(" ");
        sb.append(passThruNSRatio).append(" ");
        sb.append(windowSize).append(" ");
        sb.append(qFix);
        return sb.toString();
    }

} // end of CodaGeneratorParms class

