package org.trinet.jasi;

import java.util.Collection;

/**
 * Abstract Magnitude calculation engine. Basis for magnitude calculation engines used
 * to calculate various magnitude types.
 *
 *
 *
 * @version
 */

public abstract class MagnitudeEngine
{
  /** The magnitude calculation method. */
    public MagnitudeMethod magMethod = null;

/** Variable indicating whether or not the object is valid.  It is false until
  the Config method of a derived class sets it to otherwise. */
  protected boolean bMagnitudeEngineObjectIsValid = false;

  /** iConfigurationSource constants */
  public static final int ConfigurationSourceUndefined  = 0;
  public static final int ConfigurationSourceDatabase   = 1;
  public static final int ConfigurationSourceFile       = 2;
  public static final int ConfigurationSourceSection    = 3;
  public static final int ConfigurationSourceString     = 4;




  /* Constructor  -- DOES NOTHING!  You must use MagnitudeEngine.CreateMagnitudeEngine() */
  public MagnitudeEngine()
  {
    /* do nothing here -- on purpose */
  }



  /* Real Construction Method */
  public static MagnitudeEngine CreateMagnitudeEngine(String sClassName)
  {
            MagnitudeEngine newMagnitudeEngine = null;

        try {
            newMagnitudeEngine =  (org.trinet.jasi.MagnitudeEngine)Class.forName(sClassName).newInstance();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return newMagnitudeEngine;
  }


  /* Configuration Methods */
  /** Default configuration mode.  Configure the magnitude engine. (presumably
      with hardcoded defaults)
   **************************************/
  public abstract void ConfigureMagnitudeEngine();

  /** Catch-all configuration method.
       iConfigurationSource, specifies the source of configuration
         information (DB, file, string),
       sConfigurationLocation could be a filename, DB URL, etc.
       sConfigurationSection could be a DB table, portion of a file, etc.
       MasterChannelList is the MasterChannelList
   *********************************************************************/

  public abstract void ConfigureMagnitudeEngine(int iConfigurationSource,
                                         String sConfigurationLocation,
                                         String sConfigurationSection,
                                         ChannelList MasterChannelList
                                        );


  /** Catch-all configuration method (without MasterChannelList)
       iConfigurationSource, specifies the source of configuration
         information (DB, file, string),
       sConfigurationLocation could be a filename, DB URL, etc.
       sConfigurationSection could be a DB table, portion of a file, etc.
   *********************************************************************/
  public void ConfigureMagnitudeEngine(int iConfigurationSource,
                                String sConfigurationLocation,
                                String sConfigurationSection
                               )
  {
    ConfigureMagnitudeEngine(iConfigurationSource, sConfigurationLocation,
                             sConfigurationSection, null /* MasterChannelList */);
  }


  /** Configuration method that derives its configuration information from
       a MagnitudeMethod object.
   *********************************************************************/
//  public abstract void ConfigureMagnitudeEngine(MagnitudeMethod magMethod);

  public void ConfigureMagnitudeEngine(MagnitudeMethod magMethod) {
    setMagMethod(magMethod);
  }

  /**
   * Set the magnitude calculation method.
   * @See: MagnitudeMethod
   */
  public void setMagMethod (MagnitudeMethod magMeth) {
    this.magMethod = magMeth;
    bMagnitudeEngineObjectIsValid = true;
  }
  /**
   * Return the magnitude calculation method.
   * @See: MagnitudeMethod
   */
  public MagnitudeMethod getMagMethod() {
    return magMethod;
  }

  /** Calculation methods */

/** Magnitude Calculator
    Calculates a Magnitude from the Solution information, including the
    Solution parameters, and the associated amplitudes, codas, phases, and
    waveforms.  */
  public Magnitude solve(Solution sol)
  {
    return(solve(sol, sol.waveformList));
  }

/** Magnitude Calculator
    Calculates a Magnitude from the Solution information, including the
    Solution parameters, and the associated amplitudes, codas, phases, and
    waveforms.
    In addition to the solution waveform list, it alos utlizes the Waveforms
    waveform list.  */
  public Magnitude solve(Solution sol, Collection Waveforms)
  {
    return(solve(null, sol, Waveforms));
  }

/** Magnitude Calculator
    Calculates a Magnitude using only the channels that have codas and
    amplitudes associated with "mag".  It may use phases and waveforms from the
    Solution, for use in calculating station magnitudes, but only in conjunction
    with existing amplitudes/codas from "mag".
    I don't know that this makes a whole lot of since, but it is spec'd behavior.
    DaveKr 050802
 */
  public abstract Magnitude solve(Magnitude mag, Solution sol, Collection Waveforms);


/** Magnitude Calculator
    Calculates a Magnitude using only the channels that have codas and
    amplitudes associated with "mag".  It may use phases and waveforms from the
    Solution, for use in calculating station magnitudes, but only in conjunction
    with existing amplitudes/codas from "mag".
    I don't know that this makes a whole lot of since, but it is spec'd behavior.
    DaveKr 050802
 */
  public abstract Magnitude solve(Magnitude mag);

  public String getResultsMessage()
	{
	  return(new String(""));
	}



} // MagnitudeEngine
