package org.trinet.jasi;

import java.util.Collection;
import java.util.*;
import org.trinet.util.*;
/**
 * Title:        JASI - Java Abstract Seismic Interface
 * Description:  Your description
 * Copyright:    Copyright (c) 2001
 * Company:      USGS
 * @author Doug Given
 * @version
 */
/**
 * ChannelTimeModel that selects all channes with phase picks for the given
 * solution and constructs time windows that should include the P and S waves.
 * */
public class CTMampsOnly extends ChannelTimeWindowModel {

    protected String defModelName = "Channels w/ Amps";

    /** A string with an brief explanation of the model. For help and tooltips. */
    protected String defExplanation =
		   "Channels with amlitudes, only.";

    public CTMampsOnly( ) {
	super ();
	initModel();
    }
    public CTMampsOnly(Solution sol, ChannelableList channelSet ) {
	super (sol, channelSet);
	initModel();
    }
    public CTMampsOnly(ChannelList inputChannelSet ) {
	super(inputChannelSet);
	initModel();
    }
    public CTMampsOnly(Solution sol ) {
	super(sol);
	initModel();
    }

    protected void initModel () {
	setModelName(defModelName);
	setExplanation(defExplanation);
    }
    /** Return a Collection of Waveform objects, one for each channel represented
     *  by the objects in the ChannelableList. These may be amps, picks, etc.
     *  For example. to use this to create a list of waveforms to match a list of
     *  picks you might use: <tt>
     *   getWaveformList(sol.getPhaseList());
     * </tt>
     * The Waveforms will not contain time-series yet. To load time-series you must set
     * the loader mode with a call to Waveform.setWaveSource(Object) then load them
     * with Waveform.loadTimeSeries().<p>
     *
     * @see: Waveform
     */
    public Collection getWaveformList(ChannelableList list) {

        if (list == null || list.isEmpty()) return null;

	ArrayList wfList = new ArrayList();
	TimeSpan ts;
	Channel chan;
	double dist;

	Channelable channelable[] = new Channelable[list.size()];

	channelable = (Channelable[]) list.toArray(channelable);

	for (int i=0; i< channelable.length; i++) {

	    chan = channelable[i].getChannelObj();
	    dist = channelable[i].getDistance();
	    //if (!includeChannel(chanList[i])) continue;  // skip?
	    ts = getTimeWindow(dist);

	    Waveform wf = Waveform.create();
            wf.setChannelObj(chan);
            wf.setTimeSpan(ts);
	    wfList.add(wf);
	}

	return wfList;
    }

     /** Return a Collection with a Waveform object for each amp reading.
     * The will not contain time-series yet. To load time-series you must set
     * the loader mode with a call to Waveform.setWaveSource(Object)  then load them
     * with Waveform.loadTimeSeries().<p>
     *
     * This model needs a solution with amps to determine what channels
     * to select. Returns null if Solution is not set or if Solution has no amps.<p>
     */
     // ChannelableList
    public Collection getWaveformList() {
	if (sol == null) return null;
    	if (sol.getAmpList().isEmpty()) {
	  sol.addAmps(Amplitude.create().getBySolution(sol));
    	}
	return getWaveformList(sol.getAmpList());
    }

// ///////////////////////////////////////////////////////
    public static void main (String args[])
    {
        if (args.length <= 0) {

          System.out.println ("Usage: ChannelTimeWindowModel [evid] ");
          System.exit(0);

        }

        // event ID
	Long val = Long.valueOf(args[0]);
	long evid = (long) val.longValue();

//	DataSource db = new DataSource();
	DataSource db = new TestDataSource ();    // make connection
	System.out.println (db.toString());

	Solution sol    = Solution.create().getById(evid);

	if (sol == null) {
	    System.out.println ("No such event: "+evid);
	    System.exit(0);
	}

//        sol.addPhases( Phase.create().getBySolution(sol) );
        System.out.println (sol.toString());

	System.out.println ("Reading in current channel info...");
/*
        String compList[] = {"EH_", "HH_", "HL_", "AS_"};
    	ChannelList chanList = ChannelList.getByComponent(compList);

	//ChannelList chanList = ChannelList.smartLoad();
	System.out.println ("Read "+chanList.size()+" channels.");
*/
	CTMampsOnly model = new CTMampsOnly(sol);

	ArrayList wfList = (ArrayList) model.getWaveformList();

	if (wfList == null) {
	  System.out.println ("No channels in list");
	} else {
	  System.out.println ("Channel count = "+wfList.size());
	}

	// test loading an event from this model
	org.trinet.jiggle.MasterView mv = new org.trinet.jiggle.MasterView();
	WaveClient waveClient = null;

	mv.defineByChannelTimeWindowModel(model);
	System.out.println (mv.toString());

    }

}