package org.trinet.filters;

import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import org.trinet.jiggle.*;
import org.trinet.jasi.*;

public class WATest {

     public WATest() {
     }


// ////////////////
/**
 * Main for testing
 */
    public static void main (String args[])
    {
    /** Model of MVC for cursorLocLabel */
    CursorLocModel cursorLocModel1 = new CursorLocModel();
    CursorLocModel cursorLocModel2 = new CursorLocModel();
    CursorLocModel cursorLocModel3 = new CursorLocModel();
    CursorLocModel cursorLocModel4 = new CursorLocModel();

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource();  // make connection

//	int wfid = 10014410;        // 100 sps
//	int wfid = 10014230;        // 100 sps
     int wfid = 9031417;         // ISA HHZ

	Waveform wfx = Waveform.create();

	    wfx = wfx.getByWaveformId(wfid);

	    System.err.println ("Fetching waveform: "+wfx.getChannelObj().toString());

	    if (!wfx.loadTimeSeries()) {
		System.out.println ("Waveform retreival failed.");
          System.exit (0);
	    }

         // must look up the gain
          wfx.setChannelObj(Channel.lookUp(wfx.getChannelObj()));

          System.out.println ("channel= "+wfx.getChannelObj()+
                              "  gain= "+wfx.getChannelObj().gain.toString());

//     MagnitudeEngine magEngine = new MagnitudeEngine(new SoCalML());

     WAFilter  wafilter = new WAFilter();

     Waveform filteredWf = wafilter.filter(wfx);


     System.out.println ("Full  noise scan = "+wfx.scanForNoiseLevel());
     double start = wfx.getEpochStart();
     double end   = start + 10;
     System.out.println ("10sec noise scan = "+wfx.scanForNoiseLevel(start, end));


      wafilter.debugDump(wfx);    // debug
      wafilter.debugDump(filteredWf);    // debug



     // make a main frame
        JFrame frame = new JFrame("WA Filter Test");

     JPanel jpanel1 = new JPanel(new BorderLayout());
     ActiveWFPanel panel1 = new ActiveWFPanel(new WFView(wfx));
     panel1.setCursorLocModel(cursorLocModel1);
	// cursor position labels
	CursorLocPanel cursorPanel1 = new CursorLocPanel(cursorLocModel1);
     cursorPanel1.setAmpFormat(wfx.getAmpUnits(), wfx.getMaxAmp());
     jpanel1.add(panel1, BorderLayout.CENTER);
     jpanel1.add(cursorPanel1, BorderLayout.SOUTH);

     // filter
     JPanel jpanel2 = new JPanel(new BorderLayout());
     ActiveWFPanel panel2 = new ActiveWFPanel(new WFView(filteredWf));
     panel2.setCursorLocModel(cursorLocModel2);
	// cursor position labels
	CursorLocPanel cursorPanel2 = new CursorLocPanel(cursorLocModel2);
     cursorPanel2.setAmpFormat(filteredWf.getAmpUnits(), filteredWf.getMaxAmp());
     jpanel2.add(panel2, BorderLayout.CENTER);
     jpanel2.add(cursorPanel2, BorderLayout.SOUTH);


        jpanel1.setSize(200,200);
        jpanel1.setBackground(Color.yellow);
        jpanel2.setSize(200,200);
        jpanel2.setBackground(Color.white);


       Box box0 = Box.createVerticalBox();

       box0.add(jpanel1);
       box0.add(jpanel2);

       frame.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

	   frame.getContentPane().add(box0);

        frame.pack();
        frame.setVisible(true);
        panel1.setSize(200,500);
        panel2.setSize(200,500);
        }

}
