package org.trinet.web;

import java.text.*;
import java.awt.*;
import java.util.*;
import java.io.*;
import java.awt.event.*;
import javax.swing.*;

//import org.trinet.jdbc.*;
import org.trinet.jiggle.*;
import org.trinet.jasi.*;
/**
 * Title:        Web applications
 * Description:  Your description
 * Copyright:    Copyright (c) 2001
 * Company:      USGS
 * @author Doug Given
 * @version
 */

public class WASnapGif extends SnapGif {

    static boolean showIt = true;

    public static void main (String args[])
    {
	//	long evid = 9570828;	// Hector EQ (yikes!)
	long evid = 12448596;
	//long evid = 0;

	if (args.length < 1)	// no args
	{
	  System.out.println ("Usage: WASnapGif <evid> [ntraces] [max_secs] [out-file] ");
	  System.out.println ("           defaults:  ["+ntraces+"] ["+maxSecs+"] [<evid>.gif] ");
	  //temp// System.exit(-1);

	} else {

	    // event ID
	    Long l = Long.valueOf(args[0]);
	    evid = (long) l.longValue();
	}

	// # of traces
	if (args.length > 1) {
	  Integer val = Integer.valueOf(args[1]);
	  ntraces = (int) val.intValue();
	}

	// max. seconds to plot
	if (args.length > 2) {
	  Integer val = Integer.valueOf(args[2]);
	  maxSecs = (int) val.intValue();
	}

	// destination .gif file
	gifFile = evid + ".gif";		//default
	if (args.length > 3) {
	    gifFile = args[3];
	}

// -------------------------------------------------------

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource();  // make connection

	// Makes the .gif file, returns the grapical component in case you want
	// to display it below
	Component view = makeGif (evid, ntraces, maxSecs, gifFile);

// make a frame
	if (showIt) {

	    JFrame frame = new JFrame("SnapGif of "+evid);

	    frame.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {System.exit(-3);}
	    });

	    frame.getContentPane().add( view );	    // add scroller to frame

	    frame.pack();

	    frame.setVisible(true);

	} else {

	    // Return codes:
	    if (view == null) {
		System.err.println ("exit status = -1");
		System.exit(-1);	// failure
	    } else {
		System.err.println ("exit status = 0");
		System.exit(0);	// success
	    }
	}
    }
    /** */
    public static Component makeGif (long id, int ntraces, int maxSecs, String outFile) {

	// must make instance because makeViewWithPhases() is not static
	SnapShot snapShot =  new SnapShot();
	// station info
        MasterChannelList.set(ChannelList.smartLoad());

        if (debug) System.out.println ("Making MasterView for evid = "+id);

	// Make the "superset" MasterView
	MasterView mv = new MasterView();
	mv.setWaveFormLoadMode(MasterView.LoadAllInForeground);
        mv.setAlignmentMode(MasterView.AlignOnTime);

// read in the data!
	mv.defineByDataSource(id);

	Component view = snapShot.makeView(mv);
	view.validate();
	encodeGifFile (view, outFile);
	return view;

    }

}
