package org.trinet.util.graphics.task;
import java.awt.*;
import javax.swing.*; 

/**
  * Extension AbstractTaskMonitorPanel containing a JProgressBar 
  * monitored AbstractMonitorableTask. Panel is added to 
  * Dialog components for use in an GUI application.
  * @see AbstractTaskMonitorButtonBoxPanel
  * @see AbstractTaskMonitorDialog
  * @see TaskMonitorDialog
  * @see TaskMonitorButtonBoxDialog
  *
*/
public class TaskMonitorProgressBarPanel extends AbstractTaskMonitorPanel {
    protected int maxBarValue;

    public TaskMonitorProgressBarPanel(AbstractMonitorableTask task) {
        super(task);
    }

/**
  * Returns a JProgressBar components configured with the intiual values
  * obtained from the AbstractMonitorableTask member.
*/
    protected Object createProgressMeterComponent() {
        int taskMaxValue = task.getMaxProgressValue();
        JProgressBar progressBar = new JProgressBar(task.getMinProgressValue(), taskMaxValue);
        progressBar.setValue(task.getMinProgressValue());
        progressBar.setString(task.getProgressMessage());
        progressBar.setStringPainted(true);
        maxBarValue = taskMaxValue;
        return progressBar;
    }

/**
  * Sets the progress component values to those
  * obtained from the AbstractMonitorableTask.
  * Resets the maximum progress bound, if it has changed. 
*/
    protected synchronized void updateProgressComponent() {
        JProgressBar progressBar = (JProgressBar) progressMeter;
        int taskMaxValue = task.getMaxProgressValue();
        if (maxBarValue != taskMaxValue) {
           maxBarValue = taskMaxValue;
           progressBar.setMaximum(taskMaxValue) ; // could use a change listener?
        }
        progressBar.setValue(task.getCurrentProgressValue());
        progressBar.setString(task.getProgressMessage());
    }

/**
  * Sets the progress component values to their initial settings.
*/
    protected synchronized void resetProgressComponent() {
        JProgressBar progressBar = (JProgressBar) progressMeter;
        progressBar.setValue(progressBar.getMinimum());
        progressBar.setString("Waiting for progress update.");
    }

/**
  * Layout the progress component in the panel.
*/
    protected void initPanelLayout() {
        setLayout(new BorderLayout());
        add((Component) progressMeter, BorderLayout.CENTER);
    }
}
