package org.trinet.util.graphics.task;

import javax.swing.SwingUtilities;
import java.util.*;

import org.trinet.jasi.*;

/** Example of a task for loading a ChannelList in background thread. */
public class MonitorableChannelListTask extends AbstractMonitorableTask {

    public MonitorableChannelListTask () {
        super("ChannelList");
    }

    // implementation of abstract method
    public synchronized Object doTask() {

        // get current time
        java.sql.Date date = new java.sql.Date(System.currentTimeMillis());

        // get count of currently active channels
        int count = ChannelList.getCount(date);
        setMaxProgressValue(count);
        //System.out.println("Channel count by SQL: " + count);

        IndeterminateTaskProgressCounter counter =
                      new IndeterminateTaskProgressCounter(this, 11, 100);
        counter.start();
        ChannelList result = ChannelList.readList(date);
        currentProgressValue = result.size();
        counter.stopCounter();
        try {
           counter.join(100);
        }
        catch(InterruptedException ex) {}

        setTaskComplete(true);
        return result;
    }
    public int getMinProgressValue() {
        return 0;
    }
    public int getMaxProgressValue() {
        return (maxProgressValue <= 0) ? 3000 : maxProgressValue;
    }
    public int getCurrentProgressValue() {
        return  (currentProgressValue >= maxProgressValue) ? maxProgressValue : currentProgressValue;
    }
    public String getProgressMessage() {
//        return "Loaded " + currentProgressValue + " of " + maxProgressValue;
        int percent = (int)(((float)currentProgressValue / (float)maxProgressValue) *100f);
        return currentProgressValue + "/" + maxProgressValue+ " ("+percent+"%)";
    }

    /// DDG ...
    public static final void main(String [] args) {

        System.out.println("Creating new database connection");
        final DataSource dataSource = new DataSource(
        "jdbc:oracle:thin:@k2.gps.caltech.edu:1521:k2db",
        "oracle.jdbc.driver.OracleDriver",
        "trinetdb",
        "calgs"
        ); // use defaults

          System.out.println("Creating new thread group");
          final ThreadGroup threadGrp = new ThreadGroup("ChannelList");
          threadGrp.setDaemon(false);

// EXAMPLE progress bar monitor
        System.out.println("Waiting for channelList, loading to complete");

        // Now let's Load channelList by measured progress thread
        ChannelList channelList = null;
        MonitorableChannelListTask channelTask =
            new MonitorableChannelListTask() {
                public void finished() {
                    System.out.println("Finished channelList load count: " + ((Collection) getTaskResult()).size());
                }
            };

        channelTask.setThreadGroup(threadGrp);
        channelTask.setThreadName("ChannelList");
        channelTask.setProgressTimerDelay(100);

        TaskMonitorDialog channelDialog = new TaskMonitorDialog();
        channelDialog.setTask(channelTask);
        channelDialog.setProgressMeterVisible(true);
        channelDialog.setLocation(0,0);
        channelDialog.startTask();

        // System.out.println("MAIN: threads running: " + threadGroup.activeCount()); //DEBUG
        //threadGroup.list(); // DEBUG

        // block here til channel loading thread is done
        channelList = (ChannelList) channelTask.getTaskResult();
    }

}
