package org.trinet.util.graphics.table;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;

public class TextCellEditor extends AbstractCellEditor {
  protected int fontSize=12;
  protected Font font;
  protected JTextField component;

  public TextCellEditor() { 
    super();
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    component = new JTextField();
    component.setHorizontalAlignment(JTextField.LEFT);
    component.setFont(font);
    component.addActionListener(this);
  }
  
  public TextCellEditor(int fontSize) { 
    super();
    if (fontSize > 0) this.fontSize = fontSize;
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    component = new JTextField();
    component.setHorizontalAlignment(JTextField.LEFT);
    component.setFont(font);
    component.addActionListener(this);
  }
  
  public TextCellEditor(Font font) { 
    super();
    if (font != null) this.font = font;
    else this.font = new Font("Monospaced", Font.PLAIN, fontSize);
    component = new JTextField();
    component.setHorizontalAlignment(JTextField.LEFT);
    component.setFont(font);
    component.addActionListener(this);
  }
  
  public int getFontSize() {
    return fontSize;
  }

  public void setFontSize(int fontSize) {
    if (fontSize > 0) this.fontSize = fontSize;
    font = font.deriveFont((float) fontSize);
    component.setFont(font);
  }

//Override AbstractCellEditor methods
  public boolean startCellEditing(EventObject anEvent) {
    if(anEvent == null) component.requestFocus(); 
    else if (anEvent instanceof MouseEvent) {
      if (((MouseEvent)anEvent).getClickCount() < clickCountToStart)
        return false;
    }
    return true;
  }

  public Component getComponent() {
    return component;
  }

// Methods below should be overridden in decendent classes 
  public void setCellEditorValue(Object value) {
    if (value != null)  component.setText(value.toString());
    else  component.setText("");
    this.value = value;
  }

  public Object getCellEditorValue() {
    return component.getText();
  }

  public Component getTableCellEditorComponent( JTable table, Object value,
			 boolean isSelected, int row, int column) {
    setCellEditorValue(value);
    return (Component) component;
  }
}
