package org.trinet.util;

import org.trinet.jasi.JasiObject;

public abstract class WaveClient extends JasiObject implements java.io.Serializable
{

  int     iMaxRetries;
  int     iMaxTimeoutMilliSecs;
  boolean bVerifyWaveforms;
  boolean bTruncateAtTimeGap;
  int     iNumberOfServers;

  public static final String DEFAULT_WAVE_CLIENT="org.trinet.waveserver.rt.WaveClient";

  /* Dummy Constructor */
  public WaveClient()
  {
  }

  public static WaveClient CreateWaveClient()
	{
	  return(CreateWaveClient(DEFAULT_WAVE_CLIENT));
	}

  public static WaveClient CreateWaveClient(String sClientName)
	{
            WaveClient newWaveClient = null;

        try {
            newWaveClient =  (org.trinet.util.WaveClient)Class.forName(sClientName).newInstance();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return newWaveClient;

	}

  public WaveClient ConfigureWaveClient()
  {
    iMaxRetries = iMaxTimeoutMilliSecs = 0;
	  bVerifyWaveforms = bTruncateAtTimeGap = false;
		return(this);
  }

  public WaveClient ConfigureWaveClient(String propertyFileName)
  {
    return(ConfigureWaveClient());
  }

  public WaveClient ConfigureWaveClient(int maxRetries, int maxTimeoutMilliSecs,
                    boolean verifyWaveforms, boolean truncateAtTimeGap)
  {
	   return(ConfigureWaveClient());
	}

  public int numberOfServers()
  {
    return(iNumberOfServers);
  }

  public void setTruncatetAtTimeGap(boolean bTruncate)
  {
    bTruncateAtTimeGap = bTruncate;
  }

  public int getMaxRetries()
  {
    return(iMaxRetries);
  }

  public int setMaxRetries(int MaxRetries)
  {
    return(iMaxRetries = MaxRetries);
  }

  public int setMaxTimeoutMilliSecs(int MaxTimeoutMilliSecs)
  {
    return(iMaxTimeoutMilliSecs = MaxTimeoutMilliSecs);
  }

  public int getMaxTimeoutMilliSecs()
  {
    return(iMaxTimeoutMilliSecs);
  }

  public boolean isVerifyWaveforms()
  {
    return(bVerifyWaveforms);
  }

  public boolean setWaveformVerify(boolean bVerify)
  {
    return(bVerifyWaveforms = bVerify);
  }

  public boolean isTruncateAtTimeGap()
  {
    return(bTruncateAtTimeGap);
  }

  public boolean setTruncateAtTimeGap(boolean bTruncate)
  {
    return(bTruncateAtTimeGap = bTruncate);
  }

  public boolean addServer(String host, int port)
  {
    return(false);
  }

  public String [] listServers()
  {
    return null;
  }

  public int getJasiWaveformDataRaw(org.trinet.jasi.Waveform jasiWaveform)
	{
	  return(-1);
	}


}  /* end WaveClient */


