package org.trinet.util;

public class ParseString {
  public static String jversion =  java.lang.System.getProperty("java.version");

  public ParseString() {};

/**
 * Convert the specified field in the string to a double. String starts at offset 0.
*/ 
   public static double getDouble(String str, int start, int stop)
   { 
	String substr = "";
	double dval = Double.NaN;

	try
	{
	    substr = str.substring(start, stop);
	    dval = Double.parseDouble(substr.trim()); 
//	    if (jversion.index("1.1") != -1) {
//	    Double val = Double.valueOf(substr.trim());
//	    dval = val.doubleValue();
//	    }
	}
	catch (NumberFormatException exc)
	{
	    System.err.println ("ParseString getDouble: Double format conversion error: " + substr);
	}
	catch  (StringIndexOutOfBoundsException e)
	{
	    System.err.println ("ParseString getDouble: String out of bounds error for start, stop:" + start + ", " + stop + "\n"
		 + "\"" + str + "\"");
	}
	return dval;
   }

/**
 * Convert the specified field in the string to a double. String starts at offset 0.
*/ 
   public static float getFloat(String str, int start, int stop)
   { 
	String substr = "";
	float fval = Float.NaN;

	try
	{
	    substr = str.substring(start, stop);
	    fval = Float.parseFloat(substr.trim()); 
	}
	catch (NumberFormatException exc)
	{
	    System.err.println ("ParseString getFloat: Float format conversion error: " + substr);
	}
	catch  (StringIndexOutOfBoundsException e)
	{
	    System.err.println ("ParseString getFloat: String out of bounds error for start,stop:" + start + ", " + stop + "\n"
		 + "\"" + str + "\"");
	}
	return fval;
   }

/**
 * Convert the specified field in the string to an int value. String starts at offset 0.
 */
   public static int getInt(String str, int start, int stop)
   { 
	String substr = "";
	int ival = Integer.MIN_VALUE;
	try
	{
	    substr = str.substring(start, stop);
	    ival = Integer.parseInt(substr.trim());
//	    Integer val = Integer.valueOf(substr.trim());
//	    ival = val.intValue();
	}
	catch (NumberFormatException exc)
	{
	    System.err.println ("ParseString getInt: Integer format conversion error: /"+substr+"/");
	}
	catch (StringIndexOutOfBoundsException e)
	{
	    System.err.println ("ParseString getInt: String out of bounds error for start,stop:" + start + ", " + stop + "\n"
		 + "\"" + str + "\"");
	}
	return ival;
   }

/**
 * Convert the specified field in the string to a float value. String starts at offset 0.
 */
   public static float getIntToFloat (String str, int start, int stop, int scale)
   { 
	String substr = "";
	float fval = Float.NaN;

	try
	{
	    substr = str.substring(start, stop);
	    fval = Float.parseFloat(substr.trim());
	    fval = fval * (float) java.lang.Math.pow(10.,(double) -scale);
	}
	catch (NumberFormatException exc)
	{
	    System.err.println ("ParseString getIntToFloat: Float format conversion error: /"+substr+"/");
	} catch (StringIndexOutOfBoundsException e) {
	    System.err.println ("ParseString getIntToFloat: String out of bounds error for start,stop:" + start + ", " + stop + "\n"
		 + "\"" + str + "\"");
	}
	return fval;
   }

/**
 * Convert the specified field in the string to a char value. String starts at offset 0.
 */
   public static char getChar (String str, int start)
   { 
	char cdum = ' ';

	try
	{
	    cdum = str.charAt(start);

	}
	catch (StringIndexOutOfBoundsException e)
	{
	    System.err.println ("ParseString getChar: String out of bounds error for start:" + start + "\n" + "\"" + str + "\"");
	}
	return cdum;
   }

/**
 * Convert the specified field in the string to an String object. String starts at offset 0.
 */
   public static String getString (String str, int start, int stop)
   { 
	String substr = "";

	try
	{
	    substr = str.substring(start, stop);

	}
	catch (StringIndexOutOfBoundsException e)
	{
	    System.err.println ("ParseString getString: String out of bounds error for start,stop:" + start + ", " + stop + "\n"
		 + "\"" + str + "\"");
	}
	return substr;
   }

/**
 * Always return blanks if Index out of bounds.
 */
    public String safeSubstring(String str, int p0, int p1)
    {
	try {
	    return str.substring(p0, p1);
	} catch (StringIndexOutOfBoundsException e)
	{
	    int len = p1 - p0;
	    return "                                                     ".substring(0, len);
	}
    }

}
